/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.history.HistoricVariableInstance;

public class GetTaskFormModelCmd
implements Command<FormInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected boolean ignoreVariables;

    public GetTaskFormModelCmd(String taskId, boolean ignoreVariables) {
        this.taskId = taskId;
        this.ignoreVariables = ignoreVariables;
    }

    public FormInfo execute(CommandContext commandContext) {
        FormService formService = CommandContextUtil.getFormService();
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        TaskEntity task = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(this.taskId);
        Date endTime = null;
        if (task == null && (task = cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().getHistoricTask(this.taskId)) != null) {
            endTime = ((HistoricTaskInstance)task).getEndTime();
        }
        if (task == null) {
            throw new FlowableObjectNotFoundException("Task not found with id " + this.taskId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (!this.ignoreVariables && task.getScopeId() != null) {
            List variableInstances = cmmnEngineConfiguration.getCmmnHistoryService().createHistoricVariableInstanceQuery().caseInstanceId(task.getScopeId()).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstances) {
                variables.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
        }
        String parentDeploymentId = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getScopeDefinitionId())) {
            PlanItemDefinition itemDefinition = CaseDefinitionUtil.getCmmnModel(task.getScopeDefinitionId()).findPlanItemDefinition(task.getTaskDefinitionKey());
            boolean sameDeployment = true;
            if (itemDefinition instanceof HumanTask) {
                sameDeployment = ((HumanTask)itemDefinition).isSameDeployment();
            }
            if (sameDeployment) {
                parentDeploymentId = CaseDefinitionUtil.getDefinitionDeploymentId(task.getScopeDefinitionId(), cmmnEngineConfiguration);
            }
        }
        Object formInfo = null;
        if (this.ignoreVariables) {
            FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService();
            formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, task.getTenantId(), cmmnEngineConfiguration.isFallbackToDefaultTenant());
        } else {
            formInfo = endTime != null ? formService.getFormInstanceModelByKeyAndParentDeploymentIdAndScopeId(task.getFormKey(), parentDeploymentId, task.getScopeId(), task.getScopeType(), variables, task.getTenantId(), cmmnEngineConfiguration.isFallbackToDefaultTenant()) : formService.getFormModelWithVariablesByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, variables, task.getTenantId(), cmmnEngineConfiguration.isFallbackToDefaultTenant());
        }
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Form model for task " + task.getTaskDefinitionKey() + " cannot be found for form key " + task.getFormKey());
        }
        FormFieldHandler formFieldHandler = cmmnEngineConfiguration.getFormFieldHandler();
        formFieldHandler.enrichFormFields(formInfo);
        return formInfo;
    }
}

