/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.SignalEventListener;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class SignalEventListenerActivityBehaviour
extends CoreCmmnTriggerableActivityBehavior
implements PlanItemActivityBehavior {
    protected String signalRef;

    public SignalEventListenerActivityBehaviour(SignalEventListener signalEventListener) {
        this.signalRef = signalEventListener.getSignalRef();
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if ("terminate".equals(transition) || "exit".equals(transition) || "dismiss".equals(transition)) {
            EventSubscriptionService eventSubscriptionService = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
            List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstance.getId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
        } else if ("create".equals(transition)) {
            String signalName = null;
            if (StringUtils.isNotEmpty((CharSequence)this.signalRef)) {
                Expression signalExpression = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.signalRef);
                signalName = signalExpression.getValue((VariableContainer)planItemInstance).toString();
            }
            cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType("signal").eventName(signalName).subScopeId(planItemInstance.getId()).scopeId(planItemInstance.getCaseInstanceId()).scopeDefinitionId(planItemInstance.getCaseDefinitionId()).scopeType("cmmn").tenantId(planItemInstance.getTenantId()).create();
        }
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(planItemInstanceEntity);
        if (repetitionRule != null && ExpressionUtil.evaluateRepetitionRule(commandContext, planItemInstanceEntity, planItemInstanceEntity.getStagePlanItemInstanceEntity())) {
            PlanItemInstanceEntity eventPlanItemInstanceEntity = PlanItemInstanceUtil.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntity, false, false);
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
            agenda.planCreatePlanItemInstanceWithoutEvaluationOperation(eventPlanItemInstanceEntity);
            agenda.planOccurPlanItemInstanceOperation(eventPlanItemInstanceEntity);
            CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper().executeLifecycleListeners(commandContext, planItemInstanceEntity, "active", "available");
        } else {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            EventSubscriptionService eventSubscriptionService = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
            String signalName = null;
            if (StringUtils.isNotEmpty((CharSequence)this.signalRef)) {
                Expression signalExpression = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(this.signalRef);
                signalName = signalExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
            }
            List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstanceEntity.getId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!(eventSubscription instanceof SignalEventSubscriptionEntity) || !eventSubscription.getEventName().equals(signalName)) continue;
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
            CommandContextUtil.getAgenda(commandContext).planOccurPlanItemInstanceOperation(planItemInstanceEntity);
        }
    }
}

