/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.HashMap;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractDeleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.behavior.OnParentEndDependantActivityBehavior;
import org.flowable.cmmn.engine.impl.event.FlowableCmmnEventBuilder;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.CompletionEvaluationResult;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class TerminateCaseInstanceOperation
extends AbstractDeleteCaseInstanceOperation {
    protected boolean manualTermination;
    protected String exitCriterionId;
    protected String exitType;
    protected String exitEventType;

    public TerminateCaseInstanceOperation(CommandContext commandContext, String caseInstanceId, boolean manualTermination, String exitCriterionId, String exitType, String exitEventType) {
        super(commandContext, caseInstanceId);
        this.manualTermination = manualTermination;
        this.exitCriterionId = exitCriterionId;
        this.exitType = exitType;
        this.exitEventType = exitEventType;
    }

    @Override
    public void preRunCheck() {
        if ("complete".equals(this.exitEventType)) {
            this.checkCaseToBeCompletable();
        }
    }

    protected void checkCaseToBeCompletable() {
        boolean isAutoComplete;
        CaseInstanceEntity caseInstance = this.getCaseInstanceEntity();
        CompletionEvaluationResult completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, caseInstance, isAutoComplete = this.getPlanModel(caseInstance).isAutoComplete());
        if (!completionEvaluationResult.isCompletable()) {
            throw new FlowableIllegalArgumentException("Cannot exit case with 'complete' event type as the case '" + this.getCaseInstanceId() + "' is not yet completable. The plan item '" + completionEvaluationResult.getPlanItemInstance().getName() + " (" + completionEvaluationResult.getPlanItemInstance().getPlanItemDefinitionId() + ")' prevented it from completion.");
        }
    }

    @Override
    public String getNewState() {
        if ("complete".equals(this.exitEventType) || "forceComplete".equals(this.exitEventType)) {
            return "completed";
        }
        return "terminated";
    }

    @Override
    public void changeStateForChildPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        Object behavior = planItemInstanceEntity.getPlanItem().getBehavior();
        if (behavior instanceof OnParentEndDependantActivityBehavior) {
            ((OnParentEndDependantActivityBehavior)behavior).onParentEnd(this.commandContext, planItemInstanceEntity, this.manualTermination ? "terminate" : "exit", this.exitEventType);
        } else if (this.manualTermination) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
        } else {
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, this.exitCriterionId, null, null);
        }
    }

    @Override
    protected void invokePostLifecycleListeners() {
        super.invokePostLifecycleListeners();
        CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableCmmnEventBuilder.createCaseEndedEvent(this.caseInstanceEntity, "terminated"), "cfg.cmmnEngine");
    }

    @Override
    public String getDeleteReason() {
        return "cmmn-state-transition-terminate-case";
    }

    @Override
    public void addAdditionalCallbackData(CallbackData callbackData) {
        if (callbackData.getAdditionalData() == null) {
            callbackData.setAdditionalData(new HashMap());
        }
        callbackData.getAdditionalData().put("exitType", this.exitType);
        callbackData.getAdditionalData().put("exitEventType", this.exitEventType);
        callbackData.getAdditionalData().put("manualTermination", this.manualTermination);
    }

    @Override
    public CaseInstanceEntity getCaseInstanceEntity() {
        if (this.caseInstanceEntity == null) {
            this.caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(this.caseInstanceEntityId);
            if (this.caseInstanceEntity == null) {
                throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceEntityId);
            }
        }
        return this.caseInstanceEntity;
    }

    public boolean isManualTermination() {
        return this.manualTermination;
    }

    public void setManualTermination(boolean manualTermination) {
        this.manualTermination = manualTermination;
    }

    public String getExitCriterionId() {
        return this.exitCriterionId;
    }

    public void setExitCriterionId(String exitCriterionId) {
        this.exitCriterionId = exitCriterionId;
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String exitType) {
        this.exitType = exitType;
    }

    public String getExitEventType() {
        return this.exitEventType;
    }

    public void setExitEventType(String exitEventType) {
        this.exitEventType = exitEventType;
    }
}

