/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ReactivateCaseInstanceOperation
extends AbstractCaseInstanceOperation {
    public ReactivateCaseInstanceOperation(CommandContext commandContext, CaseInstanceEntity caseInstanceEntity) {
        super(commandContext, null, caseInstanceEntity);
    }

    @Override
    public void run() {
        super.run();
        List planItemInstances = this.caseInstanceEntity.getChildPlanItemInstances();
        ReactivateEventListener reactivateEventListener = CaseDefinitionUtil.getCase(this.caseInstanceEntity.getCaseDefinitionId()).getReactivateEventListener();
        PlanItemInstanceEntity reactivationListenerPlanItemInstance = this.searchPlanItemInstance(reactivateEventListener.getId(), planItemInstances);
        if (reactivationListenerPlanItemInstance == null) {
            throw new FlowableIllegalArgumentException("Could not find reactivation listener plan item instance in case " + this.caseInstanceEntity.getId());
        }
        PlanItemInstanceEntity reactivationListener = this.reactivatePlanItem(reactivationListenerPlanItemInstance);
        List<PlanItem> directlyReactivatedPlanItems = this.reactivateDependingPlanItems(reactivationListener, planItemInstances);
        CommandContextUtil.getAgenda(this.commandContext).planTriggerPlanItemInstanceOperation(reactivationListener);
        CommandContextUtil.getAgenda(this.commandContext).planReactivatePlanModelOperation(this.caseInstanceEntity, directlyReactivatedPlanItems);
    }

    protected List<PlanItem> reactivateDependingPlanItems(PlanItemInstanceEntity planItemInstance, List<PlanItemInstanceEntity> planItemInstances) {
        List entryDependentPlanItems = planItemInstance.getPlanItem().getEntryDependentPlanItems();
        if (entryDependentPlanItems != null) {
            for (PlanItem entryDependentPlanItem : entryDependentPlanItems) {
                this.reactivatePlanItem(this.searchPlanItemInstance(entryDependentPlanItem.getPlanItemDefinition().getId(), planItemInstances));
            }
        }
        return entryDependentPlanItems;
    }

    protected PlanItemInstanceEntity reactivatePlanItem(PlanItemInstanceEntity planItemInstance) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext);
        PlanItemInstanceEntity stagePlanItem = planItemInstance.getStagePlanItemInstanceEntity();
        if (stagePlanItem == null && planItemInstance.getStageInstanceId() != null) {
            stagePlanItem = (PlanItemInstance)planItemInstanceEntityManager.findById(planItemInstance.getStageInstanceId());
        }
        PlanItemInstanceEntity reactivatedPlanItemInstance = planItemInstanceEntityManager.createPlanItemInstanceEntityBuilder().planItem(planItemInstance.getPlanItem()).caseDefinitionId(planItemInstance.getCaseDefinitionId()).caseInstanceId(planItemInstance.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstance.getTenantId()).addToParent(true).silentNameExpressionEvaluation(false).create();
        CommandContextUtil.getAgenda(this.commandContext).planReactivatePlanItemInstanceOperation(reactivatedPlanItemInstance);
        return reactivatedPlanItemInstance;
    }

    protected PlanItemInstanceEntity searchPlanItemInstance(String planItemDefinitionId, List<PlanItemInstanceEntity> planItemInstances) {
        for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
            if (!planItemInstance.getPlanItemDefinitionId().equals(planItemDefinitionId)) continue;
            return planItemInstance;
        }
        throw new FlowableIllegalArgumentException("Could not find plan item instance for plan item with definition id " + planItemDefinitionId);
    }

    public String toString() {
        return "[Init Plan Model] initializing plan model for case instance " + this.caseInstanceEntity.getId();
    }
}

