/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.JobUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLeaveActivePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncLeaveActivePlanItemInstanceOperation.class);
    protected String transition;
    protected Map<String, String> transitionMetadata;

    public AsyncLeaveActivePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String transition, Map<String, String> transitionMetadata) {
        super(commandContext, planItemInstanceEntity);
        this.transition = transition;
        this.transitionMetadata = transitionMetadata;
    }

    @Override
    protected void internalExecute() {
        PlanItemDefinition planItemDefinition = this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
        if (!(planItemDefinition instanceof Task)) {
            throw new FlowableException("Programmatic error: this operation can only be planned for Task plan item definitions. " + this.planItemInstanceEntity);
        }
        this.createAsyncJob((Task)planItemDefinition);
    }

    protected void createAsyncJob(Task task) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        JobService jobService = cmmnEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = JobUtil.createJob(this.planItemInstanceEntity, (BaseElement)task, "cmmn-async-leave-active-plan-item-instance", cmmnEngineConfiguration);
        job.setJobHandlerConfiguration(this.createJobConfiguration());
        jobService.createAsyncJob(job, task.isAsyncLeaveExclusive());
        jobService.scheduleAsyncJob(job);
        if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Created async job for " + this.planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskAsyncJob", job, this.planItemInstanceEntity.getPlanItemDefinition(), this.planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
        }
    }

    protected String createJobConfiguration() {
        ObjectMapper objectMapper = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("operationTransition", this.transition);
        for (String key : this.transitionMetadata.keySet()) {
            objectNode.put(key, this.transitionMetadata.get(key));
        }
        try {
            return objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Programmatic error: could not create job configuration JSON", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getNewState() {
        return "async-active-leave";
    }

    @Override
    public String getLifeCycleTransition() {
        return "async-leave-active";
    }

    @Override
    public String getOperationName() {
        return "[Async leave active plan item]";
    }
}

