/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetDeploymentParentDeploymentIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newParentDeploymentId;

    public SetDeploymentParentDeploymentIdCmd(String deploymentId, String newParentDeploymentId) {
        this.deploymentId = deploymentId;
        this.newParentDeploymentId = newParentDeploymentId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        CmmnDeploymentEntity deployment = (CmmnDeploymentEntity)CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setParentDeploymentId(this.newParentDeploymentId);
        CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).update(deployment);
        return null;
    }
}

