/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.callback;

import java.util.Date;
import java.util.GregorianCalendar;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.ScopeAwareInternalJobManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DefaultInternalCmmnJobManager
extends ScopeAwareInternalJobManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultInternalCmmnJobManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected VariableScope resolveVariableScopeInternal(Job job) {
        if (job.getSubScopeId() != null) {
            return (VariableScope)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId());
        }
        return null;
    }

    protected boolean handleJobInsertInternal(Job job) {
        return true;
    }

    protected void handleJobDeleteInternal(Job job) {
    }

    protected void lockJobScopeInternal(Job job) {
        PlanItemInstanceEntity planItemInstanceEntity;
        Date lockExpirationTime;
        String lockOwner;
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        if (job instanceof JobInfoEntity) {
            lockOwner = ((JobInfoEntity)job).getLockOwner();
            lockExpirationTime = ((JobInfoEntity)job).getLockExpirationTime();
        } else {
            int lockMillis = this.cmmnEngineConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis();
            GregorianCalendar lockCal = new GregorianCalendar();
            lockCal.setTime(this.cmmnEngineConfiguration.getClock().getCurrentTime());
            lockCal.add(14, lockMillis);
            lockOwner = this.cmmnEngineConfiguration.getAsyncExecutor().getLockOwner();
            lockExpirationTime = lockCal.getTime();
        }
        caseInstanceEntityManager.updateLockTime(job.getScopeId(), lockOwner, lockExpirationTime);
        if (this.cmmnEngineConfiguration.isLoggingSessionEnabled() && job.getSubScopeId() != null && (planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId())) != null) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Locking job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskLockJob", (JobEntity)job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity, this.cmmnEngineConfiguration.getObjectMapper());
        }
    }

    protected void clearJobScopeLockInternal(Job job) {
        PlanItemInstanceEntity planItemInstanceEntity;
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        caseInstanceEntityManager.clearLockTime(job.getScopeId());
        if (this.cmmnEngineConfiguration.isLoggingSessionEnabled() && (planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId())) != null) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Unlocking job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskUnlockJob", (JobEntity)job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity, this.cmmnEngineConfiguration.getObjectMapper());
        }
    }

    protected void preTimerJobDeleteInternal(JobEntity jobEntity, VariableScope variableScope) {
    }

    protected void preRepeatedTimerScheduleInternal(TimerJobEntity timerJobEntity, VariableScope variableScope) {
        if (variableScope instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)variableScope;
            PlanItemInstanceEntity stagePlanItem = planItemInstanceEntity.getStagePlanItemInstanceEntity();
            if (stagePlanItem == null && planItemInstanceEntity.getStageInstanceId() != null) {
                stagePlanItem = (PlanItemInstance)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceEntity.getStageInstanceId());
            }
            PlanItem planItem = planItemInstanceEntity.getPlanItem();
            PlanItemInstanceEntity newPlanItemInstanceEntity = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().createPlanItemInstanceEntityBuilder().planItem(planItem).caseDefinitionId(planItemInstanceEntity.getCaseDefinitionId()).caseInstanceId(planItemInstanceEntity.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstanceEntity.getTenantId()).addToParent(true).create();
            String oldState = newPlanItemInstanceEntity.getState();
            String newState = "available";
            newPlanItemInstanceEntity.setState(newState);
            CommandContext commandContext = Context.getCommandContext();
            CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper().executeLifecycleListeners(commandContext, planItemInstanceEntity, oldState, newState);
            CommandContextUtil.getAgenda().planCreatePlanItemInstanceOperation(newPlanItemInstanceEntity);
            timerJobEntity.setSubScopeId(newPlanItemInstanceEntity.getId());
            if (planItem != null && planItem.getPlanItemDefinition() != null && planItem.getPlanItemDefinition() instanceof TimerEventListener) {
                TimerEventListener timerEventListener = (TimerEventListener)planItem.getPlanItemDefinition();
                timerJobEntity.setElementId(timerEventListener.getId());
                timerJobEntity.setElementName(timerEventListener.getName());
            }
        }
    }
}

