/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractEvaluationCriteriaOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSession;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSessionData;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateVariableEventListenersOperation
extends AbstractEvaluationCriteriaOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateVariableEventListenersOperation.class);

    public EvaluateVariableEventListenersOperation(CommandContext commandContext, String caseInstanceEntityId) {
        super(commandContext, caseInstanceEntityId, null, null);
    }

    @Override
    public void run() {
        super.run();
        if (this.caseInstanceEntity.isDeleted()) {
            this.markAsNoop();
            return;
        }
        VariableListenerSession variableListenerSession = (VariableListenerSession)this.commandContext.getSession(VariableListenerSession.class);
        Map variableSessionData = variableListenerSession.getVariableData();
        if (variableSessionData == null || variableSessionData.isEmpty()) {
            this.markAsNoop();
            return;
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        List eventSubscriptionEntities = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionEntityManager().findEventSubscriptionsByScopeIdAndType(this.caseInstanceEntity.getId(), "variable");
        boolean triggeredPlanItemInstance = false;
        for (EventSubscriptionEntity eventSubscription : eventSubscriptionEntities) {
            if (eventSubscription.isDeleted() || !variableSessionData.containsKey(eventSubscription.getEventName())) continue;
            List variableListenerDataList = (List)variableSessionData.get(eventSubscription.getEventName());
            Iterator itVariableListener = variableListenerDataList.iterator();
            while (itVariableListener.hasNext()) {
                VariableListenerSessionData variableListenerData = (VariableListenerSessionData)itVariableListener.next();
                if (!this.caseInstanceEntity.getId().equals(variableListenerData.getScopeId())) continue;
                String subScopeId = eventSubscription.getSubScopeId();
                PlanItemInstanceEntity planItemInstance = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(subScopeId);
                String configuration = eventSubscription.getConfiguration();
                String changeTypeValue = "all";
                if (StringUtils.isNotEmpty((CharSequence)configuration)) {
                    try {
                        JsonNode configNode = cmmnEngineConfiguration.getObjectMapper().readTree(configuration);
                        if (configNode.has("changeType") && !configNode.get("changeType").isNull()) {
                            changeTypeValue = configNode.get("changeType").asText();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error reading variable listener configuration value for {}", (Object)eventSubscription.getActivityId(), (Object)e);
                    }
                }
                if (!changeTypeValue.equals(variableListenerData.getChangeType()) && !"all".equals(changeTypeValue) && (!"update-create".equals(changeTypeValue) || !"create".equals(variableListenerData.getChangeType()) && !"update".equals(variableListenerData.getChangeType()))) continue;
                itVariableListener.remove();
                CommandContextUtil.getAgenda().planTriggerPlanItemInstanceOperation(planItemInstance);
                triggeredPlanItemInstance = true;
            }
        }
        if (!triggeredPlanItemInstance) {
            this.markAsNoop();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Evaluate Variable Event Listeners] case instance ");
        if (this.caseInstanceEntity != null) {
            stringBuilder.append(this.caseInstanceEntity.getId());
        } else {
            stringBuilder.append(this.caseInstanceEntityId);
        }
        return stringBuilder.toString();
    }
}

