/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.delete.BatchDeleteCaseConfig;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ComputeDeleteHistoricCaseInstanceIdsJobHandler
implements JobHandler {
    public static final String TYPE = "compute-delete-historic-case-ids";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchDeleteCaseConfig config = BatchDeleteCaseConfig.create(configuration, engineConfiguration);
        BatchPart batchPart = config.getBatchPart();
        boolean sequentialExecution = config.isSequentialExecution();
        Batch batch = config.getBatch();
        if (config.hasError()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, config.getError(), sequentialExecution);
            return;
        }
        if ("stopped".equals(batch.getStatus())) {
            batchService.completeBatchPart(batchPart.getId(), "stopped", null);
            return;
        }
        int batchSize = config.getBatchSize();
        int batchPartNumber = Integer.parseInt(batchPart.getSearchKey());
        int firstResult = batchPartNumber * batchSize;
        HistoricCaseInstanceQuery query = config.getQuery();
        List caseInstances = query.listPage(firstResult, batchSize);
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        ArrayNode idsToDelete = resultNode.putArray("caseInstanceIdsToDelete");
        for (HistoricCaseInstance caseInstance : caseInstances) {
            idsToDelete.add(caseInstance.getId());
        }
        BatchPart batchPartForDelete = engineConfiguration.getCmmnManagementService().createBatchPartBuilder(batch).type("deleteCase").searchKey(batchPart.getId()).searchKey2(batchPart.getSearchKey()).status("waiting").create();
        resultNode.put("deleteBatchPart", batchPartForDelete.getId());
        if (sequentialExecution) {
            resultNode.put("sequential", true);
            List nextComputeParts = engineConfiguration.getCmmnManagementService().createBatchPartQuery().batchId(batch.getId()).status("waiting").type("computeDeleteCaseInstanceIds").listPage(0, 2);
            boolean startDeletion = !"failed".equals(batch.getStatus());
            for (BatchPart nextComputePart : nextComputeParts) {
                if (nextComputePart.getId().equals(batchPart.getId())) continue;
                startDeletion = false;
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextComputeJob = jobService.createJob();
                nextComputeJob.setJobHandlerType(TYPE);
                nextComputeJob.setJobHandlerConfiguration(nextComputePart.getId());
                nextComputeJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextComputeJob, false);
                jobService.scheduleAsyncJob(nextComputeJob);
                break;
            }
            if (startDeletion) {
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextDeleteJob = jobService.createJob();
                nextDeleteJob.setJobHandlerType("delete-historic-case-ids");
                nextDeleteJob.setJobHandlerConfiguration(batchPartForDelete.getId());
                nextDeleteJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextDeleteJob, false);
                jobService.scheduleAsyncJob(nextDeleteJob);
            }
        }
        batchService.completeBatchPart(batchPart.getId(), "completed", resultNode.toString());
    }

    protected void failBatchPart(CmmnEngineConfiguration engineConfiguration, BatchService batchService, BatchPart batchPart, Batch batch, String resultJson, boolean sequentialExecution) {
        batchService.completeBatchPart(batchPart.getId(), "failed", resultJson);
        if (sequentialExecution) {
            this.completeBatch(batch, "failed", engineConfiguration);
        }
    }

    protected void completeBatch(Batch batch, String status, CmmnEngineConfiguration engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }
}

