/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class GetVariablesCmd
implements Command<Map<String, Object>> {
    protected String caseInstanceId;
    protected Collection<String> variableNames;

    public GetVariablesCmd(String caseInstanceId, Collection<String> variableNames) {
        this.caseInstanceId = caseInstanceId;
        this.variableNames = variableNames;
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        List variableInstanceEntities = this.variableNames == null || this.variableNames.isEmpty() ? cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService().findVariableInstanceByScopeIdAndScopeType(this.caseInstanceId, "cmmn") : cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().scopeId(this.caseInstanceId).withoutSubScopeId().scopeType("cmmn").names(this.variableNames).list();
        HashMap<String, Object> variables = new HashMap<String, Object>(variableInstanceEntities.size());
        for (VariableInstanceEntity variableInstanceEntity : variableInstanceEntities) {
            variables.put(variableInstanceEntity.getName(), variableInstanceEntity.getValue());
        }
        return variables;
    }
}

