/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.async.AbstractAsyncCmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class AsyncCmmnHistoryManager
extends AbstractAsyncCmmnHistoryManager {
    public AsyncCmmnHistoryManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    protected AsyncHistorySession getAsyncHistorySession() {
        return (AsyncHistorySession)Context.getCommandContext().getSession(AsyncHistorySession.class);
    }

    @Override
    public void recordCaseInstanceStart(CaseInstanceEntity caseInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonCaseInstanceFields(caseInstanceEntity, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-case-instance-start", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordCaseInstanceEnd(CaseInstanceEntity caseInstanceEntity, String state, Date endTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonCaseInstanceFields(caseInstanceEntity, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)endTime);
            if (caseInstanceEntity.getStartTime() != null) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"duration", (Long)(endTime.getTime() - caseInstanceEntity.getStartTime().getTime()));
            }
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"state", (String)state);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-case-instance-end", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordHistoricCaseInstanceReactivated(CaseInstanceEntity caseInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"state", (String)caseInstanceEntity.getState());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastReactivationTime", (Date)caseInstanceEntity.getLastReactivationTime());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastReactivationUserId", (String)caseInstanceEntity.getLastReactivationUserId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-case-instance-reactivate", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordUpdateCaseInstanceName(CaseInstanceEntity caseInstanceEntity, String name) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)caseInstanceEntity.getName());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)caseInstanceEntity.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-update-case-instance-name", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordUpdateBusinessKey(CaseInstanceEntity caseInstanceEntity, String businessKey) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessKey", (String)caseInstanceEntity.getBusinessKey());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)caseInstanceEntity.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-update-case-business-key", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordUpdateBusinessStatus(CaseInstanceEntity caseInstanceEntity, String businessKey) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessStatus", (String)caseInstanceEntity.getBusinessStatus());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)caseInstanceEntity.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-update-case-business-status", data, caseInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordHistoricCaseInstanceDeleted(String caseInstanceId, String tenantId) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceId);
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
            HistoricCaseInstanceEntity historicCaseInstanceEntity = (HistoricCaseInstanceEntity)historicCaseInstanceEntityManager.findById(caseInstanceId);
            if (historicCaseInstanceEntity != null) {
                this.addCommonHistoricCaseInstanceFields(historicCaseInstanceEntity, data);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-historic-case-instance-deleted", data, historicCaseInstanceEntity != null ? historicCaseInstanceEntity.getTenantId() : null);
        }
    }

    @Override
    public void recordMilestoneReached(MilestoneInstanceEntity milestoneInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonMilestoneInstanceFields(milestoneInstanceEntity, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-milestone-reached", data, milestoneInstanceEntity.getTenantId());
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE && (identityLink.getScopeId() != null || identityLink.getTaskId() != null)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonIdentityLinkFields(identityLink, data);
            CaseDefinition caseDefinition = this.getCaseDefinition(identityLink);
            if (caseDefinition != null) {
                this.addCaseDefinitionFields(data, caseDefinition);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-identity-link-created", data, caseDefinition != null ? caseDefinition.getTenantId() : null);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonIdentityLinkFields(identityLink, data);
            CaseDefinition caseDefinition = this.getCaseDefinition(identityLink);
            if (caseDefinition != null) {
                this.addCaseDefinitionFields(data, caseDefinition);
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-identity-link-deleted", data, caseDefinition != null ? caseDefinition.getTenantId() : null);
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE && entityLink.getScopeId() != null) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonEntityLinkFields(entityLink, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-entity-link-created", data, null);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonEntityLinkFields(entityLink, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-entity-link-deleted", data, null);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)createTime);
            this.addCommonVariableFields(variable, data, createTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-created", data);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable, Date updateTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonVariableFields(variable, data, updateTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-updated", data);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)variable.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)variable.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-variable-removed", data);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(task, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-created", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity task, Date changeTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(task, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUpdateTime", (Date)changeTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-updated", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, String deleteReason, Date endTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(task, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)endTime);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUpdateTime", (Date)endTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-task-removed", data, task.getTenantId());
        }
    }

    @Override
    public void recordPlanItemInstanceCreated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, null);
    }

    @Override
    public void recordPlanItemInstanceReactivated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, null);
    }

    @Override
    public void recordPlanItemInstanceUpdated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, null);
    }

    @Override
    public void recordPlanItemInstanceAvailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastAvailableTime());
    }

    @Override
    public void recordPlanItemInstanceUnavailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastUnavailableTime());
    }

    @Override
    public void recordPlanItemInstanceEnabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastEnabledTime());
    }

    @Override
    public void recordPlanItemInstanceDisabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastDisabledTime());
    }

    @Override
    public void recordPlanItemInstanceStarted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastStartedTime());
    }

    @Override
    public void recordPlanItemInstanceSuspended(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getLastSuspendedTime());
    }

    @Override
    public void recordPlanItemInstanceCompleted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getCompletedTime());
    }

    @Override
    public void recordPlanItemInstanceOccurred(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getOccurredTime());
    }

    @Override
    public void recordPlanItemInstanceTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getTerminatedTime());
    }

    @Override
    public void recordPlanItemInstanceExit(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordPlanItemInstanceFull(planItemInstanceEntity, planItemInstanceEntity.getExitTime());
    }

    @Override
    public void updateCaseDefinitionIdInHistory(CaseDefinition caseDefinition, CaseInstanceEntity caseInstance) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)caseDefinition.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)caseInstance.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-update-case-definition-cascade", data);
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        if (this.cmmnEngineConfiguration.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonHistoricTaskLogEntryFields(taskLogEntryBuilder, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-historic-user-task-log-record", data, taskLogEntryBuilder.getTenantId());
        }
    }

    @Override
    public void deleteHistoricUserTaskLogEntry(long logNumber) {
        if (this.cmmnEngineConfiguration.getTaskServiceConfiguration().isEnableHistoricTaskLogging()) {
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logNumber", (Long)logNumber);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-historic-user-task-log-delete", data);
        }
    }

    protected void recordPlanItemInstanceFull(PlanItemInstanceEntity planItemInstance, Date lastUpdateTime) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            this.removePlanItemInstanceFull(planItemInstance.getId());
            ObjectNode data = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonPlanItemInstanceFields(planItemInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUpdateTime", (Date)lastUpdateTime);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"isShowInOverview", (Boolean)this.evaluateShowInOverview(planItemInstance));
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "cmmn-plan-item-instance-full", data);
        }
    }

    protected void removePlanItemInstanceFull(String planItemInstanceId) {
        Map jobData;
        AsyncHistorySession.AsyncHistorySessionData asyncHistorySessionData;
        Map sessionData = this.getAsyncHistorySession().getSessionData();
        if (sessionData != null && (asyncHistorySessionData = (AsyncHistorySession.AsyncHistorySessionData)sessionData.get(this.getJobServiceConfiguration())) != null && (jobData = asyncHistorySessionData.getJobData()) != null && jobData.containsKey("cmmn-plan-item-instance-full")) {
            List planItemInstanceDataList = (List)jobData.get("cmmn-plan-item-instance-full");
            ListIterator planItemInstanceDataIterator = planItemInstanceDataList.listIterator();
            while (planItemInstanceDataIterator.hasNext()) {
                ObjectNode planItemInstanceData = (ObjectNode)planItemInstanceDataIterator.next();
                if (!planItemInstanceId.equals(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)planItemInstanceData, (String)"id"))) continue;
                planItemInstanceDataIterator.remove();
            }
        }
    }

    protected JobServiceConfiguration getJobServiceConfiguration() {
        return this.cmmnEngineConfiguration.getJobServiceConfiguration();
    }
}

