/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.QueryOperator;

public class ComputeDeleteHistoricCaseInstanceIdsJobHandler
implements JobHandler {
    public static final String TYPE = "compute-delete-historic-case-ids";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        HistoricCaseInstanceQuery query;
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchPart batchPart = batchService.getBatchPart(configuration);
        if (batchPart == null) {
            throw new FlowableIllegalArgumentException("There is no batch part with the id " + configuration);
        }
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        JsonNode batchConfiguration = this.getBatchConfiguration(batch, engineConfiguration);
        boolean sequentialExecution = batchConfiguration.path("sequential").booleanValue();
        JsonNode queryNode = batchConfiguration.path("query");
        if (queryNode.isMissingNode()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, this.prepareFailedResultAsJsonString("Batch configuration has no query definition", engineConfiguration), sequentialExecution);
            return;
        }
        JsonNode batchSizeNode = batchConfiguration.path("batchSize");
        if (batchSizeNode.isMissingNode()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, this.prepareFailedResultAsJsonString("Batch configuration has no batch size", engineConfiguration), sequentialExecution);
            return;
        }
        try {
            query = this.createQuery(queryNode, engineConfiguration);
        }
        catch (FlowableException exception) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, this.prepareFailedResultAsJsonString("Failed to create query", exception, engineConfiguration), sequentialExecution);
            return;
        }
        int batchSize = batchSizeNode.intValue();
        int batchPartNumber = Integer.parseInt(batchPart.getSearchKey());
        int firstResult = batchPartNumber * batchSize;
        List caseInstances = query.listPage(firstResult, batchSize);
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        ArrayNode idsToDelete = resultNode.putArray("caseInstanceIdsToDelete");
        for (HistoricCaseInstance caseInstance : caseInstances) {
            idsToDelete.add(caseInstance.getId());
        }
        BatchPart batchPartForDelete = engineConfiguration.getCmmnManagementService().createBatchPartBuilder(batch).type("deleteCase").searchKey(batchPart.getId()).searchKey2(batchPart.getSearchKey()).status("waiting").create();
        resultNode.put("deleteBatchPart", batchPartForDelete.getId());
        if (sequentialExecution) {
            resultNode.put("sequential", true);
            List nextComputeParts = engineConfiguration.getCmmnManagementService().createBatchPartQuery().batchId(batch.getId()).status("waiting").type("computeDeleteCaseInstanceIds").listPage(0, 2);
            boolean startDeletion = !"failed".equals(batch.getStatus());
            for (BatchPart nextComputePart : nextComputeParts) {
                if (nextComputePart.getId().equals(batchPart.getId())) continue;
                startDeletion = false;
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextComputeJob = jobService.createJob();
                nextComputeJob.setJobHandlerType(TYPE);
                nextComputeJob.setJobHandlerConfiguration(nextComputePart.getId());
                nextComputeJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextComputeJob, false);
                jobService.scheduleAsyncJob(nextComputeJob);
                break;
            }
            if (startDeletion) {
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextDeleteJob = jobService.createJob();
                nextDeleteJob.setJobHandlerType("delete-historic-case-ids");
                nextDeleteJob.setJobHandlerConfiguration(batchPartForDelete.getId());
                nextDeleteJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextDeleteJob, false);
                jobService.scheduleAsyncJob(nextDeleteJob);
            }
        }
        batchService.completeBatchPart(batchPart.getId(), "completed", resultNode.toString());
    }

    private void failBatchPart(CmmnEngineConfiguration engineConfiguration, BatchService batchService, BatchPart batchPart, Batch batch, String resultJson, boolean sequentialExecution) {
        batchService.completeBatchPart(batchPart.getId(), "failed", resultJson);
        if (sequentialExecution) {
            this.completeBatch(batch, "failed", engineConfiguration);
        }
    }

    protected void completeBatch(Batch batch, String status, CmmnEngineConfiguration engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }

    protected HistoricCaseInstanceQuery createQuery(JsonNode queryNode, CmmnEngineConfiguration engineConfiguration) {
        HistoricCaseInstanceQuery query = engineConfiguration.getCmmnHistoryService().createHistoricCaseInstanceQuery();
        this.populateQuery(queryNode, query, engineConfiguration);
        return query;
    }

    protected void populateQuery(JsonNode queryNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        Iterator fieldIterator = queryNode.fields();
        block86: while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String property = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            switch (property) {
                case "caseDefinitionId": {
                    query.caseDefinitionId(value.textValue());
                    continue block86;
                }
                case "caseDefinitionKey": {
                    query.caseDefinitionKey(value.textValue());
                    continue block86;
                }
                case "caseDefinitionKeys": {
                    query.caseDefinitionKeys(this.asStringSet(value));
                    continue block86;
                }
                case "caseDefinitionIds": {
                    query.caseDefinitionIds(this.asStringSet(value));
                    continue block86;
                }
                case "caseDefinitionName": {
                    query.caseDefinitionName(value.textValue());
                    continue block86;
                }
                case "caseDefinitionCategory": {
                    query.caseDefinitionCategory(value.textValue());
                    continue block86;
                }
                case "caseDefinitionVersion": {
                    query.caseDefinitionVersion(Integer.valueOf(value.intValue()));
                    continue block86;
                }
                case "caseInstanceId": {
                    query.caseInstanceId(value.textValue());
                    continue block86;
                }
                case "caseInstanceIds": {
                    query.caseInstanceIds(this.asStringSet(value));
                    continue block86;
                }
                case "caseInstanceNameLikeIgnoreCase": {
                    query.caseInstanceNameLikeIgnoreCase(value.textValue());
                    continue block86;
                }
                case "businessKey": {
                    query.caseInstanceBusinessKey(value.textValue());
                    continue block86;
                }
                case "businessStatus": {
                    query.caseInstanceBusinessStatus(value.textValue());
                    continue block86;
                }
                case "caseInstanceParentId": {
                    query.caseInstanceParentId(value.textValue());
                    continue block86;
                }
                case "withoutCaseInstanceParentId": {
                    if (!value.booleanValue()) continue block86;
                    query.withoutCaseInstanceParent();
                    continue block86;
                }
                case "deploymentId": {
                    query.deploymentId(value.textValue());
                    continue block86;
                }
                case "deploymentIds": {
                    query.deploymentIds(this.asStringList(value));
                    continue block86;
                }
                case "finished": {
                    if (!value.booleanValue()) continue block86;
                    query.finished();
                    continue block86;
                }
                case "unfinished": {
                    if (!value.booleanValue()) continue block86;
                    query.unfinished();
                    continue block86;
                }
                case "startedBefore": {
                    query.startedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block86;
                }
                case "startedAfter": {
                    query.startedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block86;
                }
                case "finishedBefore": {
                    query.finishedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block86;
                }
                case "finishedAfter": {
                    query.finishedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block86;
                }
                case "startedBy": {
                    query.startedBy(value.textValue());
                    continue block86;
                }
                case "lastReactivatedBefore": {
                    query.lastReactivatedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block86;
                }
                case "lastReactivatedAfter": {
                    query.lastReactivatedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                }
                case "lastReactivatedBy": {
                    query.lastReactivatedBy(value.textValue());
                    continue block86;
                }
                case "callbackId": {
                    query.caseInstanceCallbackId(value.textValue());
                    continue block86;
                }
                case "callbackType": {
                    query.caseInstanceCallbackType(value.textValue());
                    continue block86;
                }
                case "withoutCallbackId": {
                    if (!value.booleanValue()) continue block86;
                    query.withoutCaseInstanceCallbackId();
                    continue block86;
                }
                case "referenceId": {
                    query.caseInstanceReferenceId(value.textValue());
                    continue block86;
                }
                case "referenceType": {
                    query.caseInstanceReferenceType(value.textValue());
                    continue block86;
                }
                case "tenantId": {
                    query.caseInstanceTenantId(value.textValue());
                    continue block86;
                }
                case "withoutTenantId": {
                    if (!value.booleanValue()) continue block86;
                    query.caseInstanceWithoutTenantId();
                    continue block86;
                }
                case "activePlanItemDefinitionId": {
                    query.activePlanItemDefinitionId(value.textValue());
                    continue block86;
                }
                case "activePlanItemDefinitionIds": {
                    query.activePlanItemDefinitionIds(this.asStringSet(value));
                    continue block86;
                }
                case "involvedUser": {
                    query.involvedUser(value.textValue());
                    continue block86;
                }
                case "involvedUserIdentityLink": {
                    query.involvedUser(value.path("userId").textValue(), value.path("type").textValue());
                    continue block86;
                }
                case "involvedGroups": {
                    query.involvedGroups(this.asStringSet(value));
                    continue block86;
                }
                case "involvedGroupIdentityLink": {
                    query.involvedUser(value.path("groupId").textValue(), value.path("type").textValue());
                    continue block86;
                }
                case "queryVariableValues": {
                    this.populateQueryVariableValues(value, query, engineConfiguration);
                    continue block86;
                }
                case "orQueryObjects": {
                    this.populateOrQueryObjects(value, query, engineConfiguration);
                    continue block86;
                }
            }
            throw new FlowableIllegalArgumentException("Query property " + property + " is not supported");
        }
    }

    protected void populateOrQueryObjects(JsonNode orQueryObjectsNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        if (orQueryObjectsNode.isArray()) {
            for (JsonNode orQueryObjectNode : orQueryObjectsNode) {
                HistoricCaseInstanceQuery orQuery = query.or();
                this.populateQuery(orQueryObjectNode, orQuery, engineConfiguration);
                query.endOr();
            }
        }
    }

    protected void populateQueryVariableValues(JsonNode variableValuesNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        if (variableValuesNode.isArray()) {
            block13: for (JsonNode variableValue : variableValuesNode) {
                String operatorString = variableValue.path("operator").asText(null);
                if (operatorString == null) {
                    throw new FlowableIllegalArgumentException("The variable value does not contain an operator value");
                }
                QueryOperator operator = QueryOperator.valueOf((String)operatorString);
                String variableName = variableValue.path("name").textValue();
                switch (operator) {
                    case EQUALS: {
                        if (variableName != null) {
                            query.variableValueEquals(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                            continue block13;
                        }
                        query.variableValueEquals(this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case NOT_EQUALS: {
                        query.variableValueNotEquals(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN: {
                        query.variableValueGreaterThan(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        query.variableValueGreaterThanOrEqual(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN: {
                        query.variableValueLessThan(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        query.variableValueLessThanOrEqual(variableName, this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE: {
                        query.variableValueLike(variableName, (String)this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE_IGNORE_CASE: {
                        query.variableValueLikeIgnoreCase(variableName, (String)this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EQUALS_IGNORE_CASE: {
                        query.variableValueEqualsIgnoreCase(variableName, (String)this.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EXISTS: {
                        query.variableExists(variableName);
                        continue block13;
                    }
                    case NOT_EXISTS: {
                        query.variableNotExists(variableName);
                        continue block13;
                    }
                }
                throw new FlowableIllegalArgumentException("Operator " + operator + " is not supported for the variable value");
            }
        }
    }

    protected Object extractVariableValue(JsonNode variableValueNode, CmmnEngineConfiguration engineConfiguration) {
        String type = variableValueNode.path("type").asText(null);
        if (type == null) {
            throw new FlowableIllegalArgumentException("The variable value does not have a type");
        }
        VariableType variableType = engineConfiguration.getVariableTypes().getVariableType(type);
        return variableType.getValue((ValueFields)new VariableValueJsonNodeValueFields(variableValueNode));
    }

    protected List<String> asStringList(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return values;
        }
        return null;
    }

    protected Set<String> asStringSet(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return new HashSet<String>(values);
        }
        return null;
    }

    protected JsonNode getBatchConfiguration(Batch batch, CmmnEngineConfiguration engineConfiguration) {
        try {
            return engineConfiguration.getObjectMapper().readTree(batch.getBatchDocumentJson("cfg.cmmnEngine"));
        }
        catch (JsonProcessingException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
            return null;
        }
    }

    protected String prepareFailedResultAsJsonString(String errorMessage, CmmnEngineConfiguration engineConfiguration) {
        return this.prepareFailedResultAsJsonString(errorMessage, null, engineConfiguration);
    }

    protected String prepareFailedResultAsJsonString(String errorMessage, FlowableException exception, CmmnEngineConfiguration engineConfiguration) {
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        resultNode.put("errorMessage", errorMessage);
        if (exception != null) {
            resultNode.put("errorStacktrace", ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return resultNode.toString();
    }

    protected static class VariableValueJsonNodeValueFields
    implements ValueFields {
        protected final JsonNode node;

        public VariableValueJsonNodeValueFields(JsonNode node) {
            this.node = node;
        }

        public String getName() {
            return this.node.path("name").textValue();
        }

        public String getProcessInstanceId() {
            throw new UnsupportedOperationException("Not supported to get process instance id");
        }

        public String getExecutionId() {
            throw new UnsupportedOperationException("Not supported to get execution id");
        }

        public String getScopeId() {
            throw new UnsupportedOperationException("Not supported to get scope id");
        }

        public String getSubScopeId() {
            throw new UnsupportedOperationException("Not supported to get sub scope id");
        }

        public String getScopeType() {
            throw new UnsupportedOperationException("Not supported to scope type");
        }

        public String getTaskId() {
            throw new UnsupportedOperationException("Not supported to get task id");
        }

        public String getTextValue() {
            return this.node.path("textValue").textValue();
        }

        public void setTextValue(String textValue) {
            throw new UnsupportedOperationException("Not supported to set text value");
        }

        public String getTextValue2() {
            return this.node.path("textValues").textValue();
        }

        public void setTextValue2(String textValue2) {
            throw new UnsupportedOperationException("Not supported to set text value2");
        }

        public Long getLongValue() {
            JsonNode longNode = this.node.path("longValue");
            if (longNode.isNumber()) {
                return longNode.longValue();
            }
            return null;
        }

        public void setLongValue(Long longValue) {
            throw new UnsupportedOperationException("Not supported to set long value");
        }

        public Double getDoubleValue() {
            JsonNode doubleNode = this.node.path("doubleValue");
            if (doubleNode.isNumber()) {
                return doubleNode.doubleValue();
            }
            return null;
        }

        public void setDoubleValue(Double doubleValue) {
            throw new UnsupportedOperationException("Not supported to set double value");
        }

        public byte[] getBytes() {
            throw new UnsupportedOperationException("Not supported to get bytes");
        }

        public void setBytes(byte[] bytes) {
            throw new UnsupportedOperationException("Not supported to set bytes");
        }

        public Object getCachedValue() {
            throw new UnsupportedOperationException("Not supported to set get cached value");
        }

        public void setCachedValue(Object cachedValue) {
            throw new UnsupportedOperationException("Not supported to set cached value");
        }
    }
}

