/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import java.util.Collection;
import java.util.Map;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.api.BatchPartBuilder;
import org.flowable.batch.api.BatchPartQuery;
import org.flowable.batch.api.BatchQuery;
import org.flowable.batch.service.BatchPartBuilderImpl;
import org.flowable.batch.service.impl.BatchBuilderImpl;
import org.flowable.batch.service.impl.BatchPartQueryImpl;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.runtime.CmmnExternalWorkerTransitionBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.DeleteBatchCmd;
import org.flowable.cmmn.engine.impl.cmd.GetTableNamesCmd;
import org.flowable.cmmn.engine.impl.cmd.HandleHistoryCleanupTimerJobCmd;
import org.flowable.cmmn.engine.impl.runtime.CmmnExternalWorkerTransitionBuilderImpl;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.tenant.ChangeTenantIdBuilder;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cmd.GetTableCountCmd;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.common.engine.impl.tenant.ChangeTenantIdBuilderImpl;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.ExternalWorkerJobAcquireBuilder;
import org.flowable.job.api.ExternalWorkerJobFailureBuilder;
import org.flowable.job.api.ExternalWorkerJobQuery;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.HistoryJobQuery;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.ExternalWorkerJobAcquireBuilderImpl;
import org.flowable.job.service.impl.ExternalWorkerJobFailureBuilderImpl;
import org.flowable.job.service.impl.ExternalWorkerJobQueryImpl;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.cmd.DeleteDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.DeleteHistoryJobCmd;
import org.flowable.job.service.impl.cmd.DeleteJobCmd;
import org.flowable.job.service.impl.cmd.DeleteSuspendedJobCmd;
import org.flowable.job.service.impl.cmd.DeleteTimerJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteHistoryJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteJobCmd;
import org.flowable.job.service.impl.cmd.GetHistoryJobAdvancedConfigurationCmd;
import org.flowable.job.service.impl.cmd.GetJobExceptionStacktraceCmd;
import org.flowable.job.service.impl.cmd.JobType;
import org.flowable.job.service.impl.cmd.MoveDeadLetterJobToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.MoveDeadLetterJobToHistoryJobCmd;
import org.flowable.job.service.impl.cmd.MoveJobToDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.MoveSuspendedJobToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.MoveTimerToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.SetJobRetriesCmd;
import org.flowable.job.service.impl.cmd.SetTimerJobRetriesCmd;

public class CmmnManagementServiceImpl
extends CommonEngineServiceImpl<CmmnEngineConfiguration>
implements CmmnManagementService {
    public CmmnManagementServiceImpl(CmmnEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public Map<String, Long> getTableCounts() {
        return (Map)this.commandExecutor.execute((Command)new GetTableCountCmd("cfg.cmmnEngine"));
    }

    public Collection<String> getTableNames() {
        return (Collection)this.commandExecutor.execute((Command)new GetTableNamesCmd());
    }

    public void executeJob(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Job id is null");
        }
        try {
            this.commandExecutor.execute((Command)new ExecuteJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
        }
        catch (RuntimeException e) {
            if (e instanceof FlowableException) {
                throw e;
            }
            throw new FlowableException("Job " + jobId + " failed", (Throwable)e);
        }
    }

    public void executeHistoryJob(String historyJobId) {
        this.commandExecutor.execute((Command)new ExecuteHistoryJobCmd(historyJobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public String getHistoryJobHistoryJson(String historyJobId) {
        return (String)this.commandExecutor.execute((Command)new GetHistoryJobAdvancedConfigurationCmd(historyJobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void deleteHistoryJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteHistoryJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public Job moveTimerToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveTimerToExecutableJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public Job moveJobToDeadLetterJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveJobToDeadLetterJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public Job moveDeadLetterJobToExecutableJob(String jobId, int retries) {
        return (Job)this.commandExecutor.execute((Command)new MoveDeadLetterJobToExecutableJobCmd(jobId, retries, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public HistoryJob moveDeadLetterJobToHistoryJob(String jobId, int retries) {
        return (HistoryJob)this.commandExecutor.execute((Command)new MoveDeadLetterJobToHistoryJobCmd(jobId, retries, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public Job moveSuspendedJobToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveSuspendedJobToExecutableJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void deleteJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void deleteTimerJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteTimerJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void deleteSuspendedJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteSuspendedJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void deleteDeadLetterJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteDeadLetterJobCmd(jobId, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetJobRetriesCmd(jobId, retries, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void setTimerJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetTimerJobRetriesCmd(jobId, retries, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public ExternalWorkerJobQuery createExternalWorkerJobQuery() {
        return new ExternalWorkerJobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public TimerJobQuery createTimerJobQuery() {
        return new TimerJobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public SuspendedJobQuery createSuspendedJobQuery() {
        return new SuspendedJobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public DeadLetterJobQuery createDeadLetterJobQuery() {
        return new DeadLetterJobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public String getJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.ASYNC, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public String getTimerJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.TIMER, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public String getSuspendedJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.SUSPENDED, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public String getDeadLetterJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.DEADLETTER, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public String getExternalWorkerJobErrorDetails(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.EXTERNAL_WORKER, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration()));
    }

    public void handleHistoryCleanupTimerJob() {
        this.commandExecutor.execute((Command)new HandleHistoryCleanupTimerJobCmd());
    }

    public BatchQuery createBatchQuery() {
        return new BatchQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getBatchServiceConfiguration());
    }

    public BatchBuilder createBatchBuilder() {
        return new BatchBuilderImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getBatchServiceConfiguration());
    }

    public BatchPartQuery createBatchPartQuery() {
        return new BatchPartQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getBatchServiceConfiguration());
    }

    public BatchPartBuilder createBatchPartBuilder(Batch batch) {
        return new BatchPartBuilderImpl(batch, ((CmmnEngineConfiguration)((Object)this.configuration)).getBatchServiceConfiguration(), this.commandExecutor);
    }

    public void deleteBatch(String batchId) {
        this.commandExecutor.execute((Command)new DeleteBatchCmd(batchId));
    }

    public HistoryJobQuery createHistoryJobQuery() {
        return new HistoryJobQueryImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public ExternalWorkerJobAcquireBuilder createExternalWorkerJobAcquireBuilder() {
        return new ExternalWorkerJobAcquireBuilderImpl(this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public ExternalWorkerJobFailureBuilder createExternalWorkerJobFailureBuilder(String externalJobId, String workerId) {
        return new ExternalWorkerJobFailureBuilderImpl(externalJobId, workerId, this.commandExecutor, ((CmmnEngineConfiguration)((Object)this.configuration)).getJobServiceConfiguration());
    }

    public CmmnExternalWorkerTransitionBuilder createCmmnExternalWorkerTransitionBuilder(String externalJobId, String workerId) {
        return new CmmnExternalWorkerTransitionBuilderImpl(this.commandExecutor, externalJobId, workerId);
    }

    public ChangeTenantIdBuilder createChangeTenantIdBuilder(String fromTenantId, String toTenantId) {
        return new ChangeTenantIdBuilderImpl(fromTenantId, toTenantId, ((CmmnEngineConfiguration)((Object)this.configuration)).getChangeTenantIdManager());
    }

    public <T> T executeCommand(Command<T> command) {
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(command);
    }

    public <T> T executeCommand(CommandConfig config, Command<T> command) {
        if (config == null) {
            throw new FlowableIllegalArgumentException("The config is null");
        }
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(config, command);
    }
}

