/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import org.flowable.cmmn.api.listener.CaseInstanceLifecycleListener;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;

public class DelegateExpressionCaseLifecycleListener
implements CaseInstanceLifecycleListener {
    protected String sourceState;
    protected String targetState;
    protected Expression expression;
    protected List<FieldExtension> fieldExtensions;

    public DelegateExpressionCaseLifecycleListener(String sourceState, String targetState, Expression expression, List<FieldExtension> fieldExtensions) {
        this.sourceState = sourceState;
        this.targetState = targetState;
        this.expression = expression;
        this.fieldExtensions = fieldExtensions;
    }

    public String getSourceState() {
        return this.sourceState;
    }

    public String getTargetState() {
        return this.targetState;
    }

    public void stateChanged(CaseInstance caseInstance, String oldState, String newState) {
        block5: {
            try {
                CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstance;
                Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)caseInstanceEntity, this.fieldExtensions);
                if (delegate instanceof CaseInstanceLifecycleListener) {
                    try {
                        CaseInstanceLifecycleListener listener = (CaseInstanceLifecycleListener)delegate;
                        listener.stateChanged((CaseInstance)caseInstanceEntity, oldState, newState);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new FlowableException("Exception while invoking CaseInstanceLifeCycleListener: " + e.getMessage(), (Throwable)e);
                    }
                }
                throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + CaseInstanceLifecycleListener.class);
            }
            catch (Exception e) {
                throw new FlowableException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

