/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.db;

import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.EngineDatabaseConfiguration;
import org.flowable.common.engine.impl.db.LiquibaseBasedSchemaManager;
import org.flowable.common.engine.impl.db.LiquibaseDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.idm.engine.IdmEngineConfiguration;

public class CmmnDbSchemaManager
extends LiquibaseBasedSchemaManager {
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml";
    public static final String LIQUIBASE_CHANGELOG_CRDB = "org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog-crdb.xml";

    public CmmnDbSchemaManager(String changelogFile) {
        super("cmmn", changelogFile, "ACT_CMMN_");
    }

    protected LiquibaseDatabaseConfiguration getDatabaseConfiguration() {
        return new EngineDatabaseConfiguration((AbstractEngineConfiguration)CommandContextUtil.getCmmnEngineConfiguration());
    }

    public void initSchema() {
        this.initSchema(CommandContextUtil.getCmmnEngineConfiguration().getDatabaseSchemaUpdate());
    }

    public void initSchema(String databaseSchemaUpdate) {
        AbstractEngineConfiguration abstractEngineConfiguration;
        super.initSchema(databaseSchemaUpdate);
        if ("drop-create".equals(databaseSchemaUpdate) && (abstractEngineConfiguration = (AbstractEngineConfiguration)CommandContextUtil.getCmmnEngineConfiguration().getEngineConfigurations().get("cfg.idmEngine")) != null) {
            IdmEngineConfiguration idmEngineConfiguration = (IdmEngineConfiguration)abstractEngineConfiguration;
            idmEngineConfiguration.getSchemaManager().schemaCreate();
        }
    }

    public void schemaCreate() {
        try {
            this.getCommonSchemaManager().schemaCreate();
            this.getIdentityLinkSchemaManager().schemaCreate();
            this.getEntityLinkSchemaManager().schemaCreate();
            this.getEventSubscriptionSchemaManager().schemaCreate();
            this.getTaskSchemaManager().schemaCreate();
            this.getVariableSchemaManager().schemaCreate();
            this.getJobSchemaManager().schemaCreate();
            super.schemaCreate();
        }
        catch (Exception e) {
            throw new FlowableException("Error creating CMMN engine tables", (Throwable)e);
        }
    }

    public void schemaDrop() {
        try {
            super.schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping CMMN engine tables", (Throwable)e);
        }
        try {
            this.getJobSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping job tables", (Throwable)e);
        }
        try {
            this.getVariableSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getTaskSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping task tables", (Throwable)e);
        }
        try {
            this.getEventSubscriptionSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping event subscription tables", (Throwable)e);
        }
        try {
            this.getEntityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping entity link tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String schemaUpdate() {
        try {
            this.getCommonSchemaManager().schemaUpdate();
            if (CommandContextUtil.getCmmnEngineConfiguration().isExecuteServiceSchemaManagers()) {
                this.getIdentityLinkSchemaManager().schemaUpdate();
                this.getEntityLinkSchemaManager().schemaUpdate();
                this.getEventSubscriptionSchemaManager().schemaUpdate();
                this.getTaskSchemaManager().schemaUpdate();
                this.getVariableSchemaManager().schemaUpdate();
                this.getJobSchemaManager().schemaUpdate();
            }
            super.schemaUpdate();
        }
        catch (Exception e) {
            throw new FlowableException("Error updating CMMN engine tables", (Throwable)e);
        }
        return null;
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getCommonSchemaManager();
    }

    protected SchemaManager getIdentityLinkSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getIdentityLinkSchemaManager();
    }

    protected SchemaManager getEntityLinkSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getEntityLinkSchemaManager();
    }

    protected SchemaManager getEventSubscriptionSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getEventSubscriptionSchemaManager();
    }

    protected SchemaManager getVariableSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getVariableSchemaManager();
    }

    protected SchemaManager getTaskSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getTaskSchemaManager();
    }

    protected SchemaManager getJobSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getJobSchemaManager();
    }
}

