/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractNeedsCaseInstanceCmd
implements Command<Void>,
Serializable {
    protected String caseInstanceId;

    public AbstractNeedsCaseInstanceCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("Cannot find case instance for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        this.internalExecute(commandContext, caseInstanceEntity);
        return null;
    }

    protected abstract void internalExecute(CommandContext var1, CaseInstanceEntity var2);
}

