/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.scripting;

import java.util.Optional;
import java.util.stream.Stream;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.variable.api.delegate.VariableScope;

public class CmmnVariableScopeResolver
implements Resolver {
    protected CmmnEngineConfiguration engineConfiguration;
    protected VariableScope variableScope;

    public CmmnVariableScopeResolver(CmmnEngineConfiguration engineConfiguration, VariableScope variableScope) {
        if (variableScope == null) {
            throw new FlowableIllegalArgumentException("variableScope cannot be null");
        }
        this.variableScope = variableScope;
        this.engineConfiguration = engineConfiguration;
    }

    public boolean containsKey(Object key) {
        return this.variableScope.hasVariable((String)key) || CmmnEngineVariableScopeNames.getVariableScopeByName((String)key).isPresent();
    }

    public Object get(Object key) {
        return CmmnEngineVariableScopeNames.getVariableScopeByName((String)key).map(t -> {
            switch (t) {
                case EngineConfiguration: {
                    return this.engineConfiguration;
                }
                case HistoryService: {
                    return this.engineConfiguration.getCmmnHistoryService();
                }
                case ManagementService: {
                    return this.engineConfiguration.getCmmnManagementService();
                }
                case RuntimeService: {
                    return this.engineConfiguration.getCmmnRuntimeService();
                }
                case TaskService: {
                    return this.engineConfiguration.getCmmnTaskService();
                }
                case Execution: {
                    return this.variableScope;
                }
            }
            return null;
        }).orElse(this.variableScope.getVariable((String)key));
    }

    public static enum CmmnEngineVariableScopeNames {
        EngineConfiguration("cmmnEngineConfiguration"),
        RuntimeService("cmmnRuntimeService"),
        HistoryService("cmmnHistoryService"),
        ManagementService("cmmnManagementService"),
        TaskService("cmmnTaskService"),
        Execution("planItemInstance");

        String name;

        private CmmnEngineVariableScopeNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Stream<CmmnEngineVariableScopeNames> stream() {
            return Stream.of(CmmnEngineVariableScopeNames.values());
        }

        public static Optional<CmmnEngineVariableScopeNames> getVariableScopeByName(String name) {
            return CmmnEngineVariableScopeNames.stream().filter(v -> v.name.equals(name)).findFirst();
        }
    }
}

