/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delegate;

import java.util.List;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemJavaDelegate;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.PlanItemJavaDelegateActivityBehavior;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.variable.api.delegate.VariableScope;

public class CmmnClassDelegate
implements CmmnActivityBehavior {
    protected String className;
    protected List<FieldExtension> fieldExtensions;
    protected CmmnActivityBehavior activityBehaviorInstance;

    public CmmnClassDelegate(String className, List<FieldExtension> fieldExtensions) {
        this.className = className;
        this.fieldExtensions = fieldExtensions;
    }

    @Override
    public void execute(DelegatePlanItemInstance planItemInstance) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getCmmnActivityBehavior(this.className, (VariableScope)planItemInstance);
        }
        this.activityBehaviorInstance.execute(planItemInstance);
    }

    protected CmmnActivityBehavior getCmmnActivityBehavior(String className, VariableScope variableScope) {
        Object instance = this.instantiate(className);
        CmmnClassDelegate.applyFieldExtensions(this.fieldExtensions, instance, (VariableContainer)variableScope, false);
        if (instance instanceof PlanItemJavaDelegate) {
            return new PlanItemJavaDelegateActivityBehavior((PlanItemJavaDelegate)instance);
        }
        if (instance instanceof CmmnActivityBehavior) {
            return (CmmnActivityBehavior)instance;
        }
        throw new FlowableIllegalArgumentException(className + " does not implement the " + CmmnActivityBehavior.class + " nor the " + PlanItemJavaDelegate.class + " interface");
    }

    protected Object instantiate(String className) {
        return ReflectUtil.instantiate((String)className);
    }

    public static void applyFieldExtensions(List<FieldExtension> fieldExtensions, Object target, VariableContainer variableContainer, boolean throwExceptionOnMissingField) {
        if (fieldExtensions != null) {
            for (FieldExtension fieldExtension : fieldExtensions) {
                CmmnClassDelegate.applyFieldExtension(fieldExtension, target, variableContainer, throwExceptionOnMissingField);
            }
        }
    }

    protected static void applyFieldExtension(FieldExtension fieldExtension, Object target, VariableContainer variableContainer, boolean throwExceptionOnMissingField) {
        String value = null;
        if (fieldExtension.getStringValue() != null) {
            value = fieldExtension.getStringValue();
        } else if (fieldExtension.getExpression() != null) {
            ExpressionManager expressionManager = CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager();
            value = expressionManager.createExpression(fieldExtension.getExpression());
        }
        ReflectUtil.invokeSetterOrField((Object)target, (String)fieldExtension.getFieldName(), (Object)value, (boolean)throwExceptionOnMissingField);
    }
}

