/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.data.AbstractCmmnDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseDefinitionDataManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionQueryImpl;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;

public class MybatisCaseDefinitionDataManager
extends AbstractCmmnDataManager<CaseDefinitionEntity>
implements CaseDefinitionDataManager {
    public MybatisCaseDefinitionDataManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends CaseDefinitionEntity> getManagedEntityClass() {
        return CaseDefinitionEntityImpl.class;
    }

    public CaseDefinitionEntity create() {
        return new CaseDefinitionEntityImpl();
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKey(String caseDefinitionKey) {
        return (CaseDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestCaseDefinitionByKey", (Object)caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("caseDefinitionKey", caseDefinitionKey);
        params.put("tenantId", tenantId);
        return (CaseDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestCaseDefinitionByKeyAndTenantId", params);
    }

    @Override
    public void deleteCaseDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteCaseDefinitionsByDeploymentId", (Object)deploymentId, CaseDefinitionEntityImpl.class);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        return (CaseDefinitionEntity)this.getDbSqlSession().selectOne("selectCaseDefinitionByDeploymentAndKey", parameters);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String caseDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (CaseDefinitionEntity)this.getDbSqlSession().selectOne("selectCaseDefinitionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByKeyAndVersion(String caseDefinitionKey, Integer caseDefinitionVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseDefinitionKey", caseDefinitionKey);
        params.put("caseDefinitionVersion", caseDefinitionVersion);
        List results = this.getDbSqlSession().selectList("selectCaseDefinitionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (CaseDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " case definitions with key = '" + caseDefinitionKey + "' and version = '" + caseDefinitionVersion + "'.");
        }
        return null;
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByKeyAndVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseDefinitionKey", caseDefinitionKey);
        params.put("caseDefinitionVersion", caseDefinitionVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectCaseDefinitionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (CaseDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " case definitions with key = '" + caseDefinitionKey + "' and version = '" + caseDefinitionVersion + "'.");
        }
        return null;
    }

    @Override
    public void updateCaseDefinitionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateCaseDefinitionTenantIdForDeploymentId", params);
    }

    @Override
    public List<CaseDefinition> findCaseDefinitionsByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery) {
        return this.getDbSqlSession().selectList("selectCaseDefinitionsByQueryCriteria", (ListQueryParameterObject)caseDefinitionQuery);
    }

    @Override
    public long findCaseDefinitionCountByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectCaseDefinitionCountByQueryCriteria", (Object)caseDefinitionQuery);
    }
}

