/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.deployer;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.engine.common.api.repository.EngineResource;

public class ResourceNameUtil {
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn.xml", "cmmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};

    public static String stripCmmnFileSuffix(String cmmnFileResource) {
        for (String suffix : CMMN_RESOURCE_SUFFIXES) {
            if (!cmmnFileResource.endsWith(suffix)) continue;
            return cmmnFileResource.substring(0, cmmnFileResource.length() - suffix.length());
        }
        return cmmnFileResource;
    }

    public static String getCaseDiagramResourceName(String cmmnFileResource, String caseKey, String diagramSuffix) {
        String cmmnFileResourceBase = ResourceNameUtil.stripCmmnFileSuffix(cmmnFileResource);
        return cmmnFileResourceBase + caseKey + "." + diagramSuffix;
    }

    public static String getCaseDiagramResourceNameFromDeployment(CaseDefinitionEntity caseDefinition, Map<String, EngineResource> resources) {
        if (StringUtils.isEmpty((CharSequence)caseDefinition.getResourceName())) {
            throw new IllegalStateException("Provided case definition must have its resource name set.");
        }
        String cmmnResourceBase = ResourceNameUtil.stripCmmnFileSuffix(caseDefinition.getResourceName());
        String key = caseDefinition.getKey();
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String possibleName = cmmnResourceBase + key + "." + diagramSuffix;
            if (resources.containsKey(possibleName)) {
                return possibleName;
            }
            possibleName = cmmnResourceBase + diagramSuffix;
            if (!resources.containsKey(possibleName)) continue;
            return possibleName;
        }
        return null;
    }
}

