/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartCaseInstanceWithFormCmd
implements Command<CaseInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartCaseInstanceWithFormCmd.class);
    protected CaseInstanceBuilder caseInstanceBuilder;

    public StartCaseInstanceWithFormCmd(CaseInstanceBuilder caseInstanceBuilder) {
        this.caseInstanceBuilder = caseInstanceBuilder;
    }

    public CaseInstance execute(CommandContext commandContext) {
        CmmnModel cmmnModel;
        Case caze;
        Stage planModel;
        if (this.caseInstanceBuilder == null) {
            throw new FlowableIllegalArgumentException("Cannot start case instance: no case instance builder provided");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CmmnDeploymentManager deploymentCache = cmmnEngineConfiguration.getDeploymentManager();
        CaseDefinition caseDefinition = deploymentCache.findDeployedCaseDefinitionById(this.caseInstanceBuilder.getCaseDefinitionId());
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("No case definition found for id = '" + this.caseInstanceBuilder.getCaseDefinitionId() + "'", CaseDefinition.class);
        }
        FormInfo formInfo = null;
        Map formVariables = null;
        FormService formService = CommandContextUtil.getFormService();
        if ((this.caseInstanceBuilder.getVariables() != null || this.caseInstanceBuilder.getOutcome() != null) && (planModel = (caze = (cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinition.getId())).getCaseById(caseDefinition.getKey())).getPlanModel()) != null && StringUtils.isNotEmpty((CharSequence)planModel.getFormKey())) {
            FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService();
            if (formRepositoryService != null) {
                formInfo = formRepositoryService.getFormModelByKey(planModel.getFormKey());
                if (formInfo != null) {
                    formVariables = formService.getVariablesFromFormSubmission(formInfo, this.caseInstanceBuilder.getVariables(), this.caseInstanceBuilder.getOutcome());
                }
            } else {
                LOGGER.warn("Requesting form model {} without configured formRepositoryService", (Object)planModel.getFormKey());
            }
        }
        CaseInstanceEntity caseInstance = cmmnEngineConfiguration.getCaseInstanceHelper().startCaseInstance(this.caseInstanceBuilder);
        if (formInfo != null) {
            formService.createFormInstanceWithScopeId(formVariables, formInfo, null, caseInstance.getId(), "cmmn", caseInstance.getCaseDefinitionId());
            FormFieldHandler formFieldHandler = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, null, caseInstance.getId(), "cmmn", this.caseInstanceBuilder.getVariables());
        }
        return caseInstance;
    }
}

