/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class GetTasksLocalVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> taskIds;

    public GetTasksLocalVariablesCmd(Set<String> taskIds) {
        this.taskIds = taskIds;
    }

    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.taskIds == null) {
            throw new FlowableIllegalArgumentException("taskIds is null");
        }
        if (this.taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of taskIds is empty");
        }
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        List entities = CommandContextUtil.getVariableService().findVariableInstancesByTaskIds(this.taskIds);
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add((VariableInstance)entity);
        }
        return instances;
    }
}

