/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class GetDeploymentResourceCmd
implements Command<InputStream> {
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    public InputStream execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        if (this.resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        CmmnResourceEntity resource = CommandContextUtil.getCmmnResourceEntityManager(commandContext).findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        if (resource == null) {
            if (CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).findById(this.deploymentId) == null) {
                throw new FlowableObjectNotFoundException("deployment does not exist: " + this.deploymentId, CmmnDeploymentEntity.class);
            }
            throw new FlowableObjectNotFoundException("no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", CmmnResourceEntity.class);
        }
        return new ByteArrayInputStream(resource.getBytes());
    }
}

