/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.CaseInstanceState;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.EntityWithSentryPartInstances;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateCriteriaOperation
extends AbstractCaseInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateCriteriaOperation.class);
    protected PlanItemLifeCycleEvent planItemLifeCycleEvent;
    protected boolean evaluateCaseInstanceCompleted;

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId) {
        super(commandContext, caseInstanceEntityId, null);
    }

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        super(commandContext, caseInstanceEntityId, null);
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    @Override
    public void run() {
        super.run();
        CriteriaEvaluationResult planModelExitCriteriaEvaluationResult = this.evaluateExitCriteria(this.caseInstanceEntity, (HasExitCriteria)this.getPlanModel(this.caseInstanceEntity));
        if (CriteriaEvaluationResult.SENTRY_SATISFIED.equals((Object)planModelExitCriteriaEvaluationResult)) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminateCaseInstanceOperation(this.caseInstanceEntity.getId(), false);
        } else {
            boolean criteriaChangeOrActiveChildren = this.evaluatePlanItemsCriteria(this.caseInstanceEntity);
            if (this.evaluateCaseInstanceCompleted && !criteriaChangeOrActiveChildren && !CaseInstanceState.END_STATES.contains(this.caseInstanceEntity.getState()) && this.isPlanModelComplete()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No active plan items found for plan model, completing case instance");
                }
                CommandContextUtil.getAgenda(this.commandContext).planCompleteCaseInstanceOperation(this.caseInstanceEntity);
            }
        }
    }

    protected boolean evaluatePlanItemsCriteria(PlanItemInstanceContainer planItemInstanceContainer) {
        List<PlanItemInstanceEntity> planItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        int activeChildren = 0;
        boolean criteriaChanged = false;
        ArrayList<PlanItemInstanceEntity> newChildPlanItemInstances = null;
        for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstances) {
            PlanItem planItem = planItemInstanceEntity.getPlanItem();
            CriteriaEvaluationResult evaluationResult = null;
            String state = planItemInstanceEntity.getState();
            if (PlanItemInstanceState.EVALUATE_ENTRY_CRITERIA_STATES.contains(state) && (evaluationResult = this.evaluateEntryCriteria(planItemInstanceEntity, planItem)).equals((Object)CriteriaEvaluationResult.SENTRY_SATISFIED)) {
                boolean activatePlanItemInstance = true;
                if (!planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null) {
                    boolean isRepeating = this.evaluateRepetitionRule(planItemInstanceEntity);
                    if (isRepeating) {
                        if (newChildPlanItemInstances == null) {
                            newChildPlanItemInstances = new ArrayList<PlanItemInstanceEntity>(1);
                        }
                        PlanItemInstanceEntity childPlanItemInstanceEntity = this.copyAndInsertPlanItemInstance(this.commandContext, planItemInstanceEntity, false);
                        childPlanItemInstanceEntity.setState("wait_repetition");
                        int counter = this.getRepetitionCounter(childPlanItemInstanceEntity);
                        this.setRepetitionCounter(childPlanItemInstanceEntity, ++counter);
                        newChildPlanItemInstances.add(childPlanItemInstanceEntity);
                    } else {
                        activatePlanItemInstance = false;
                    }
                } else if (planItem.getPlanItemDefinition() instanceof EventListener) {
                    activatePlanItemInstance = false;
                }
                if (activatePlanItemInstance) {
                    criteriaChanged = true;
                    CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(planItemInstanceEntity);
                }
            }
            if (!PlanItemInstanceState.END_STATES.contains(state)) {
                evaluationResult = this.evaluateExitCriteria(planItemInstanceEntity, (HasExitCriteria)planItem);
                if (evaluationResult.equals((Object)CriteriaEvaluationResult.SENTRY_SATISFIED)) {
                    criteriaChanged = true;
                    CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity);
                } else if (planItem.getPlanItemDefinition() instanceof Stage) {
                    if ("active".equals(state)) {
                        boolean criteriaChangeOrActiveChildrenForStage = this.evaluatePlanItemsCriteria(planItemInstanceEntity);
                        if (criteriaChangeOrActiveChildrenForStage) {
                            criteriaChanged = true;
                            planItemInstanceEntity.setCompleteable(false);
                        } else {
                            Stage stage = (Stage)planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
                            if (this.isStageCompletable(planItemInstanceEntity, stage)) {
                                criteriaChanged = true;
                                CommandContextUtil.getAgenda(this.commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
                            }
                        }
                    }
                } else if ("active".equals(state)) {
                    ++activeChildren;
                }
            }
            if (planItemInstanceEntity.getState() != null) continue;
            criteriaChanged = true;
        }
        if (newChildPlanItemInstances != null) {
            for (PlanItemInstanceEntity newChildPlanItemInstance : newChildPlanItemInstances) {
                planItemInstanceContainer.getChildPlanItemInstances().add(newChildPlanItemInstance);
            }
        }
        return criteriaChanged || activeChildren > 0;
    }

    protected CriteriaEvaluationResult evaluateEntryCriteria(PlanItemInstanceEntity planItemInstanceEntity, PlanItem planItem) {
        List criteria = planItem.getEntryCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(planItemInstanceEntity, criteria);
        }
        return CriteriaEvaluationResult.SENTRY_SATISFIED;
    }

    protected CriteriaEvaluationResult evaluateExitCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, HasExitCriteria hasExitCriteria) {
        List criteria = hasExitCriteria.getExitCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(entityWithSentryPartInstances, criteria);
        }
        return CriteriaEvaluationResult.NONE;
    }

    protected CriteriaEvaluationResult evaluateCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, List<Criterion> criteria) {
        boolean partTriggered = false;
        for (Criterion entryCriterion : criteria) {
            Sentry sentry = entryCriterion.getSentry();
            if (sentry.getOnParts().size() == 1 && sentry.getSentryIfPart() == null) {
                SentryOnPart sentryOnPart;
                if (this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart = (SentryOnPart)sentry.getOnParts().get(0))) continue;
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            if (sentry.getOnParts().isEmpty() && sentry.getSentryIfPart() != null) {
                if (!this.evaluateSentryIfPart(sentry, entityWithSentryPartInstances)) continue;
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            boolean sentryIfPartSatisfied = false;
            HashSet<String> satisfiedSentryOnPartIds = new HashSet<String>(1);
            for (SentryPartInstanceEntity sentryPartInstanceEntity : entityWithSentryPartInstances.getSatisfiedSentryPartInstances()) {
                if (sentryPartInstanceEntity.getOnPartId() != null) {
                    satisfiedSentryOnPartIds.add(sentryPartInstanceEntity.getOnPartId());
                    continue;
                }
                if (sentryPartInstanceEntity.getIfPartId() == null || !sentryPartInstanceEntity.getIfPartId().equals(sentry.getSentryIfPart().getId())) continue;
                sentryIfPartSatisfied = true;
            }
            boolean criteriaSatisfied = false;
            for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
                if (satisfiedSentryOnPartIds.contains(sentryOnPart.getId()) || this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart)) continue;
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentryOnPart, null);
                satisfiedSentryOnPartIds.add(sentryOnPart.getId());
                criteriaSatisfied = true;
            }
            if (sentry.getSentryIfPart() != null && !sentryIfPartSatisfied && this.evaluateSentryIfPart(sentry, entityWithSentryPartInstances)) {
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, null, sentry.getSentryIfPart());
                sentryIfPartSatisfied = true;
                criteriaSatisfied = true;
            }
            if (entityWithSentryPartInstances.getSatisfiedSentryPartInstances().size() == sentry.getOnParts().size() + (sentry.getSentryIfPart() != null ? 1 : 0)) {
                return CriteriaEvaluationResult.SENTRY_SATISFIED;
            }
            if (!criteriaSatisfied) continue;
            partTriggered = true;
        }
        return partTriggered ? CriteriaEvaluationResult.PART_TRIGGERED : CriteriaEvaluationResult.NONE;
    }

    public boolean sentryOnPartMatchesCurrentLifeCycleEvent(SentryOnPart sentryOnPart) {
        return this.planItemLifeCycleEvent.getPlanItem().getId().equals(sentryOnPart.getSourceRef()) && this.planItemLifeCycleEvent.getTransition().equals(sentryOnPart.getStandardEvent());
    }

    protected SentryPartInstanceEntity createSentryPartInstanceEntity(EntityWithSentryPartInstances entityWithSentryPartInstances, SentryOnPart sentryOnPart, SentryIfPart sentryIfPart) {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = CommandContextUtil.getSentryPartInstanceEntityManager(this.commandContext);
        SentryPartInstanceEntity sentryPartInstanceEntity = (SentryPartInstanceEntity)sentryPartInstanceEntityManager.create();
        sentryPartInstanceEntity.setTimeStamp(CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getClock().getCurrentTime());
        if (sentryOnPart != null) {
            sentryPartInstanceEntity.setOnPartId(sentryOnPart.getId());
        } else if (sentryIfPart != null) {
            sentryPartInstanceEntity.setIfPartId(sentryIfPart.getId());
        }
        if (entityWithSentryPartInstances instanceof CaseInstanceEntity) {
            sentryPartInstanceEntity.setCaseInstanceId(((CaseInstanceEntity)entityWithSentryPartInstances).getId());
            sentryPartInstanceEntity.setCaseDefinitionId(((CaseInstanceEntity)entityWithSentryPartInstances).getCaseDefinitionId());
        } else if (entityWithSentryPartInstances instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)entityWithSentryPartInstances;
            sentryPartInstanceEntity.setCaseInstanceId(planItemInstanceEntity.getCaseInstanceId());
            sentryPartInstanceEntity.setCaseDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            sentryPartInstanceEntity.setPlanItemInstanceId(planItemInstanceEntity.getId());
            if (entityWithSentryPartInstances instanceof CountingPlanItemInstanceEntity) {
                CountingPlanItemInstanceEntity countingPlanItemInstanceEntity = (CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity);
                countingPlanItemInstanceEntity.setSentryPartInstanceCount(countingPlanItemInstanceEntity.getSentryPartInstanceCount() + 1);
            }
        }
        sentryPartInstanceEntityManager.insert(sentryPartInstanceEntity);
        entityWithSentryPartInstances.getSatisfiedSentryPartInstances().add(sentryPartInstanceEntity);
        return sentryPartInstanceEntity;
    }

    protected boolean evaluateSentryIfPart(Sentry sentry, EntityWithSentryPartInstances entityWithSentryPartInstances) {
        Expression conditionExpression = CommandContextUtil.getExpressionManager(this.commandContext).createExpression(sentry.getSentryIfPart().getCondition());
        Object result = conditionExpression.getValue((VariableContainer)entityWithSentryPartInstances);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    protected boolean isEndStateReachedForAllRequiredChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState())) continue;
                if (this.isRequiredPlanItemInstance(childPlanItemInstance)) {
                    return false;
                }
                return this.isEndStateReachedForAllChildPlanItems(childPlanItemInstance);
            }
        }
        return true;
    }

    protected boolean isRequiredPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemControl planItemControl = planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getRequiredRule() != null) {
            boolean isRequired = true;
            String requiredCondition = planItemControl.getRequiredRule().getCondition();
            if (StringUtils.isNotEmpty((CharSequence)requiredCondition)) {
                isRequired = this.evaluateBooleanExpression(this.commandContext, planItemInstanceEntity, requiredCondition);
            }
            return isRequired;
        }
        return false;
    }

    protected boolean isEndStateReachedForAllChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (!PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState())) {
                    return false;
                }
                boolean allChildChildsEndStateReached = this.isEndStateReachedForAllChildPlanItems(childPlanItemInstance);
                if (allChildChildsEndStateReached) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isAvailableChildPlanCompletionNeutralOrNotActive(PlanItemInstanceContainer planItemInstanceContainer) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState()) || "available".contains(childPlanItemInstance.getState()) && this.isCompletionNeutralPlanItemInstance(childPlanItemInstance)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isCompletionNeutralPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemControl planItemControl = planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getCompletionNeutralRule() != null) {
            boolean isCompletionNeutral = true;
            String condition = planItemControl.getCompletionNeutralRule().getCondition();
            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                isCompletionNeutral = this.evaluateBooleanExpression(this.commandContext, planItemInstanceEntity, condition);
            }
            return isCompletionNeutral;
        }
        return false;
    }

    protected boolean isStageCompletable(PlanItemInstanceEntity stagePlanItemInstanceEntity, Stage stage) {
        boolean allRequiredChildrenInEndState = this.isEndStateReachedForAllRequiredChildPlanItems(stagePlanItemInstanceEntity);
        if (allRequiredChildrenInEndState) {
            stagePlanItemInstanceEntity.setCompleteable(true);
        }
        if (stagePlanItemInstanceEntity.isCompleteable()) {
            if (stage.isAutoComplete()) {
                return true;
            }
            return this.isAvailableChildPlanCompletionNeutralOrNotActive(stagePlanItemInstanceEntity);
        }
        return false;
    }

    protected boolean isPlanModelComplete() {
        boolean allRequiredChildrenInEndState = this.isEndStateReachedForAllRequiredChildPlanItems(this.caseInstanceEntity);
        if (allRequiredChildrenInEndState) {
            this.caseInstanceEntity.setCompleteable(true);
        }
        boolean isAutoComplete = CaseDefinitionUtil.getCase(this.caseInstanceEntity.getCaseDefinitionId()).getPlanModel().isAutoComplete();
        if (this.caseInstanceEntity.isCompleteable()) {
            if (isAutoComplete) {
                return true;
            }
            return this.isAvailableChildPlanCompletionNeutralOrNotActive(this.caseInstanceEntity);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Evaluate Criteria] case instance ");
        if (this.caseInstanceEntity != null) {
            stringBuilder.append(this.caseInstanceEntity.getId());
        } else {
            stringBuilder.append(this.caseInstanceEntityId);
        }
        if (this.planItemLifeCycleEvent != null) {
            stringBuilder.append(" with transition '").append(this.planItemLifeCycleEvent.getTransition()).append("' having fired");
            if (this.planItemLifeCycleEvent.getPlanItem() != null) {
                stringBuilder.append(" for plan item ").append(this.planItemLifeCycleEvent.getPlanItem().getId());
                if (this.planItemLifeCycleEvent.getPlanItem().getName() != null) {
                    stringBuilder.append(" (").append(this.planItemLifeCycleEvent.getPlanItem().getName()).append(")");
                }
            }
        }
        return stringBuilder.toString();
    }

    public PlanItemLifeCycleEvent getPlanItemLifeCycleEvent() {
        return this.planItemLifeCycleEvent;
    }

    public void setPlanItemLifeCycleEvent(PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    public boolean isEvaluateCaseInstanceCompleted() {
        return this.evaluateCaseInstanceCompleted;
    }

    public void setEvaluateCaseInstanceCompleted(boolean evaluateCaseInstanceCompleted) {
        this.evaluateCaseInstanceCompleted = evaluateCaseInstanceCompleted;
    }

    private static enum CriteriaEvaluationResult {
        SENTRY_SATISFIED,
        SENTRY_SATISFIED_BUT_IGNORED,
        PART_TRIGGERED,
        NONE;

    }
}

