/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.api.runtime.PlanItemInstance;

public class StateTransition {
    public static Map<String, Set<String>> TRANSITIONS = new HashMap<String, Set<String>>();

    protected static void addTransition(String state, String ... transitions) {
        TRANSITIONS.put(state, new HashSet(transitions.length));
        for (String transition : transitions) {
            TRANSITIONS.get(state).add(transition);
        }
    }

    public static boolean isPossible(PlanItemInstance planItemInstance, String transition) {
        return StateTransition.isPossible(planItemInstance.getState(), transition);
    }

    public static boolean isPossible(String currentState, String transition) {
        return TRANSITIONS.get(currentState).contains(transition);
    }

    static {
        StateTransition.addTransition(null, "create");
        StateTransition.addTransition("wait_repetition", "create");
        StateTransition.addTransition("available", "start", "enable", "parentSuspend", "exit");
        StateTransition.addTransition("enabled", "disable", "manualStart", "parentSuspend", "exit");
        StateTransition.addTransition("disabled", "reenable", "parentSuspend", "exit");
        StateTransition.addTransition("active", "fault", "complete", "suspend", "terminate", "parentSuspend", "exit");
        StateTransition.addTransition("failed", "reactivate", "exit");
        StateTransition.addTransition("suspended", "resume", "parentResume", "exit");
        StateTransition.addTransition("completed", new String[0]);
        StateTransition.addTransition("terminated", new String[0]);
    }
}

