/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity.data.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.AbstractCmmnDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.impl.matcher.CaseInstanceByCaseDefinitionIdMatcher;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.db.CachedEntityMatcher;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;

public class MybatisCaseInstanceDataManagerImpl
extends AbstractCmmnDataManager<CaseInstanceEntity>
implements CaseInstanceDataManager {
    protected CaseInstanceByCaseDefinitionIdMatcher caseInstanceByCaseDefinitionIdMatcher = new CaseInstanceByCaseDefinitionIdMatcher();

    public MybatisCaseInstanceDataManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends CaseInstanceEntity> getManagedEntityClass() {
        return CaseInstanceEntityImpl.class;
    }

    public CaseInstanceEntity create() {
        CaseInstanceEntityImpl caseInstanceEntityImpl = new CaseInstanceEntityImpl();
        caseInstanceEntityImpl.setChildPlanItemInstances(new ArrayList<PlanItemInstanceEntity>(1));
        caseInstanceEntityImpl.setSatisfiedSentryPartInstances(new ArrayList<SentryPartInstanceEntity>(1));
        caseInstanceEntityImpl.internalSetVariableInstances(new HashMap(1));
        return caseInstanceEntityImpl;
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.getList("selectCaseInstancesByCaseDefinitionId", caseDefinitionId, (CachedEntityMatcher)this.caseInstanceByCaseDefinitionIdMatcher, true);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQueryImpl query) {
        return this.getDbSqlSession().selectList("selectCaseInstancesByQueryCriteria", (ListQueryParameterObject)query);
    }

    @Override
    public long countByCriteria(CaseInstanceQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectCaseInstanceCountByQueryCriteria", (Object)query);
    }

    @Override
    public void deleteByCaseDefinitionId(String caseDefinitionId) {
        this.getDbSqlSession().delete("deleteCaseInstanceByCaseDefinitionId", (Object)caseDefinitionId, this.getManagedEntityClass());
    }

    @Override
    public void updateLockTime(String caseInstanceId, Date lockDate, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", caseInstanceId);
        params.put("lockTime", lockDate);
        params.put("expirationTime", expirationTime);
        int result = this.getDbSqlSession().update("updateCaseInstanceLockTime", params);
        if (result == 0) {
            throw new FlowableOptimisticLockingException("Could not lock case instance");
        }
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", caseInstanceId);
        this.getDbSqlSession().update("clearCaseInstanceLockTime", params);
    }
}

