/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntityManager;

public class CaseInstanceEntityManagerImpl
extends AbstractCmmnEntityManager<CaseInstanceEntity>
implements CaseInstanceEntityManager {
    protected CaseInstanceDataManager caseInstanceDataManager;

    public CaseInstanceEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseInstanceDataManager caseInstanceDataManager) {
        super(cmmnEngineConfiguration);
        this.caseInstanceDataManager = caseInstanceDataManager;
    }

    @Override
    protected DataManager<CaseInstanceEntity> getDataManager() {
        return this.caseInstanceDataManager;
    }

    @Override
    public CaseInstanceQuery createCaseInstanceQuery() {
        return new CaseInstanceQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.caseInstanceDataManager.findCaseInstancesByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.findByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public long countByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.countByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public void deleteByCaseDefinitionId(String caseDefinitionId) {
        this.caseInstanceDataManager.deleteByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public void deleteCaseInstanceAndRelatedData(String caseInstanceId, String deleteReason) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)this.caseInstanceDataManager.findById(caseInstanceId);
        VariableInstanceEntityManager variableInstanceEntityManager = this.getVariableInstanceEntityManager();
        List variableInstanceEntities = variableInstanceEntityManager.findVariableInstanceByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (VariableInstanceEntity variableInstanceEntity : variableInstanceEntities) {
            variableInstanceEntityManager.delete((Entity)variableInstanceEntity);
        }
        TaskEntityManager taskEntityManager = this.getTaskEntityManager();
        List taskEntities = taskEntityManager.findTasksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (TaskEntity taskEntity : taskEntities) {
            TaskHelper.deleteTask(taskEntity, deleteReason, false, true);
        }
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = this.getSentryPartInstanceEntityManager();
        List sentryPartInstances = caseInstanceEntity.getSatisfiedSentryPartInstances();
        for (SentryPartInstanceEntity sentryPartInstanceEntity : sentryPartInstances) {
            sentryPartInstanceEntityManager.delete(sentryPartInstanceEntity);
        }
        MilestoneInstanceEntityManager milestoneInstanceEntityManager = this.getMilestoneInstanceEntityManager();
        List<MilestoneInstanceEntity> milestoneInstanceEntities = milestoneInstanceEntityManager.findMilestoneInstancesByCaseInstanceId(caseInstanceId);
        if (milestoneInstanceEntities != null) {
            for (MilestoneInstanceEntity milestoneInstanceEntity : milestoneInstanceEntities) {
                milestoneInstanceEntityManager.delete(milestoneInstanceEntity);
            }
        }
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.getPlanItemInstanceEntityManager();
        List<PlanItemInstanceEntity> planItemInstanceEntities = planItemInstanceEntityManager.findAllChildPlanItemInstancesForCaseInstance(caseInstanceId);
        Collections.reverse(planItemInstanceEntities);
        if (planItemInstanceEntities != null) {
            for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceEntities) {
                if (planItemInstanceEntity.getSatisfiedSentryPartInstances() != null) {
                    for (SentryPartInstanceEntity sentryPartInstanceEntity : planItemInstanceEntity.getSatisfiedSentryPartInstances()) {
                        sentryPartInstanceEntityManager.delete(sentryPartInstanceEntity);
                    }
                }
                planItemInstanceEntityManager.delete(planItemInstanceEntity);
            }
        }
        JobEntityManager jobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getJobEntityManager();
        List jobs = jobEntityManager.findJobsByQueryCriteria(new JobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job job : jobs) {
            jobEntityManager.delete(job.getId());
        }
        TimerJobEntityManager timerJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getTimerJobEntityManager();
        List timerJobs = timerJobEntityManager.findJobsByQueryCriteria(new TimerJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job timerJob : timerJobs) {
            timerJobEntityManager.delete(timerJob.getId());
        }
        SuspendedJobEntityManager suspendedJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getSuspendedJobEntityManager();
        List suspendedJobs = suspendedJobEntityManager.findJobsByQueryCriteria(new SuspendedJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job suspendedJob : suspendedJobs) {
            suspendedJobEntityManager.delete(suspendedJob.getId());
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getDeadLetterJobEntityManager();
        List deadLetterJobs = deadLetterJobEntityManager.findJobsByQueryCriteria(new DeadLetterJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job deadLetterJob : deadLetterJobs) {
            deadLetterJobEntityManager.delete(deadLetterJob.getId());
        }
        this.delete(caseInstanceEntity);
    }

    @Override
    public void updateLockTime(String caseInstanceId) {
        Date expirationTime = this.getCmmnEngineConfiguration().getClock().getCurrentTime();
        int lockMillis = this.getCmmnEngineConfiguration().getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        Date lockDate = lockCal.getTime();
        this.caseInstanceDataManager.updateLockTime(caseInstanceId, lockDate, expirationTime);
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        this.caseInstanceDataManager.clearLockTime(caseInstanceId);
    }
}

