/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangeCaseInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public abstract class AbstractDeleteCaseInstanceOperation
extends AbstractChangeCaseInstanceStateOperation {
    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, String caseInstanceId) {
        super(commandContext, caseInstanceId);
    }

    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, CaseInstanceEntity caseInstanceEntity) {
        super(commandContext, caseInstanceEntity);
    }

    @Override
    public void run() {
        super.run();
        this.deleteCaseInstance();
    }

    protected void deleteCaseInstance() {
        this.deleteRuntimeData();
        CommandContextUtil.getCaseInstanceHelper(this.commandContext).callCaseInstanceStateChangeCallbacks(this.commandContext, this.caseInstanceEntity, this.caseInstanceEntity.getState(), this.getNewState());
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordCaseInstanceEnd(this.caseInstanceEntityId);
    }

    protected void deleteRuntimeData() {
        List childPlanItemInstances = this.caseInstanceEntity.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!"active".equals(childPlanItemInstance.getState()) && !"available".equals(childPlanItemInstance.getState())) continue;
                this.changeStateForChildPlanItemInstance(childPlanItemInstance);
            }
        }
        CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).deleteCaseInstanceAndRelatedData(this.caseInstanceEntity.getId(), this.getDeleteReason());
    }

    protected abstract String getDeleteReason();
}

