/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.model.ChildTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.IOParameter;

public abstract class AbstractChildTaskExport<T extends ChildTask>
extends AbstractPlanItemDefinitionExport<T> {
    @Override
    protected void writePlanItemDefinitionSpecificAttributes(T planItemDefinition, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)planItemDefinition.getBusinessKey())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "businessKey", planItemDefinition.getBusinessKey());
        }
        if (planItemDefinition.isInheritBusinessKey()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "inheritBusinessKey", String.valueOf(planItemDefinition.isInheritBusinessKey()));
        }
    }

    @Override
    protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, T planItemDefinition, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
        boolean extensionElementWritten = super.writePlanItemDefinitionExtensionElements(model, planItemDefinition, didWriteExtensionElement, xtw);
        extensionElementWritten = this.writeIOParameters("in", planItemDefinition.getInParameters(), extensionElementWritten, xtw);
        extensionElementWritten = this.writeIOParameters("out", planItemDefinition.getOutParameters(), extensionElementWritten, xtw);
        return extensionElementWritten;
    }

    protected boolean writeIOParameters(String elementName, List<IOParameter> parameterList, boolean didWriteParameterStartElement, XMLStreamWriter xtw) throws Exception {
        if (parameterList == null || parameterList.isEmpty()) {
            return didWriteParameterStartElement;
        }
        for (IOParameter ioParameter : parameterList) {
            if (!didWriteParameterStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteParameterStartElement = true;
            }
            xtw.writeStartElement("flowable", elementName, "http://flowable.org/cmmn");
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSource())) {
                xtw.writeAttribute("source", ioParameter.getSource());
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                xtw.writeAttribute("sourceExpression", ioParameter.getSourceExpression());
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTarget())) {
                xtw.writeAttribute("target", ioParameter.getTarget());
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTargetExpression())) {
                xtw.writeAttribute("targetExpression", ioParameter.getTargetExpression());
            }
            xtw.writeEndElement();
        }
        return didWriteParameterStartElement;
    }
}

