/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.event;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import javax.enterprise.inject.spi.BeanManager;
import org.flowable.cdi.BusinessProcessEvent;
import org.flowable.cdi.BusinessProcessEventType;
import org.flowable.cdi.annotation.event.AssignTaskLiteral;
import org.flowable.cdi.annotation.event.BusinessProcessLiteral;
import org.flowable.cdi.annotation.event.CompleteTaskLiteral;
import org.flowable.cdi.annotation.event.CreateTaskLiteral;
import org.flowable.cdi.annotation.event.DeleteTaskLiteral;
import org.flowable.cdi.impl.event.CdiBusinessProcessEvent;
import org.flowable.cdi.impl.util.BeanManagerLookup;
import org.flowable.cdi.impl.util.ProgrammaticBeanLookup;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.variable.api.delegate.VariableScope;

public class CdiTaskListener
implements TaskListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final BusinessProcessEventType type;
    protected final String transitionName;
    protected final String activityId;

    public CdiTaskListener(String transitionName) {
        this.type = BusinessProcessEventType.TAKE;
        this.transitionName = transitionName;
        this.activityId = null;
    }

    public CdiTaskListener(String activityId, BusinessProcessEventType type) {
        this.type = type;
        this.transitionName = null;
        this.activityId = activityId;
    }

    public void notify(DelegateTask task) {
        try {
            ProgrammaticBeanLookup.lookup(ProcessEngine.class);
        }
        catch (Exception e) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(task);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.getBeanManager().fireEvent((Object)event, qualifiers);
    }

    protected BusinessProcessEvent createEvent(DelegateTask task) {
        ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
        ProcessDefinition processDefinition = ((ProcessDefinitionCacheEntry)engineConfiguration.getProcessDefinitionCache().get(task.getProcessDefinitionId())).getProcessDefinition();
        Date now = engineConfiguration.getClock().getCurrentTime();
        return new CdiBusinessProcessEvent(this.activityId, this.transitionName, processDefinition, (VariableScope)task, this.type, task.getProcessInstanceId(), task.getExecutionId(), now);
    }

    protected BeanManager getBeanManager() {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        if (bm == null) {
            throw new FlowableException("No cdi bean manager available, cannot publish event.");
        }
        return bm;
    }

    protected Annotation[] getQualifiers(BusinessProcessEvent event) {
        BusinessProcessLiteral businessProcessQualifier = new BusinessProcessLiteral(event.getProcessDefinition().getKey());
        if (this.type == BusinessProcessEventType.CREATE_TASK) {
            return new Annotation[]{businessProcessQualifier, new CreateTaskLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.ASSIGN_TASK) {
            return new Annotation[]{businessProcessQualifier, new AssignTaskLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.COMPLETE_TASK) {
            return new Annotation[]{businessProcessQualifier, new CompleteTaskLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.DELETE_TASK) {
            return new Annotation[]{businessProcessQualifier, new DeleteTaskLiteral(this.activityId)};
        }
        return new Annotation[0];
    }
}

