/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.event;

import java.util.HashSet;
import java.util.Set;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BusinessRuleTask;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EventGateway;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.ManualTask;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.bpmn.model.SendTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.Transaction;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cdi.BusinessProcessEventType;
import org.flowable.cdi.impl.event.CdiExecutionListener;
import org.flowable.cdi.impl.event.CdiTaskListener;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.parse.BpmnParseHandler;

public class CdiEventSupportBpmnParseHandler
implements BpmnParseHandler {
    protected static final Set<Class<? extends BaseElement>> supportedTypes = new HashSet<Class<? extends BaseElement>>();

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        return supportedTypes;
    }

    public void parse(BpmnParse bpmnParse, BaseElement element) {
        if (element instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)element;
            CdiExecutionListener listener = new CdiExecutionListener(sequenceFlow.getId());
            this.addListenerToElement((FlowElement)sequenceFlow, "take", listener);
        } else {
            if (element instanceof UserTask) {
                UserTask userTask = (UserTask)element;
                this.addCreateListener(userTask);
                this.addAssignListener(userTask);
                this.addCompleteListener(userTask);
                this.addDeleteListener(userTask);
            }
            if (element instanceof FlowElement) {
                FlowElement flowElement = (FlowElement)element;
                this.addStartEventListener(flowElement);
                this.addEndEventListener(flowElement);
            }
        }
    }

    private void addCompleteListener(UserTask userTask) {
        this.addListenerToUserTask(userTask, "complete", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.COMPLETE_TASK));
    }

    private void addAssignListener(UserTask userTask) {
        this.addListenerToUserTask(userTask, "assignment", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.ASSIGN_TASK));
    }

    private void addCreateListener(UserTask userTask) {
        this.addListenerToUserTask(userTask, "create", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.CREATE_TASK));
    }

    protected void addDeleteListener(UserTask userTask) {
        this.addListenerToUserTask(userTask, "delete", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.DELETE_TASK));
    }

    protected void addStartEventListener(FlowElement flowElement) {
        CdiExecutionListener listener = new CdiExecutionListener(flowElement.getId(), BusinessProcessEventType.START_ACTIVITY);
        this.addListenerToElement(flowElement, "start", listener);
    }

    protected void addEndEventListener(FlowElement flowElement) {
        CdiExecutionListener listener = new CdiExecutionListener(flowElement.getId(), BusinessProcessEventType.END_ACTIVITY);
        this.addListenerToElement(flowElement, "end", listener);
    }

    protected void addListenerToElement(FlowElement flowElement, String event, Object instance) {
        FlowableListener listener = new FlowableListener();
        listener.setEvent(event);
        listener.setImplementationType("instance");
        listener.setInstance(instance);
        flowElement.getExecutionListeners().add(listener);
    }

    protected void addListenerToUserTask(UserTask userTask, String event, Object instance) {
        FlowableListener listener = new FlowableListener();
        listener.setEvent(event);
        listener.setImplementationType("instance");
        listener.setInstance(instance);
        userTask.getTaskListeners().add(listener);
    }

    static {
        supportedTypes.add(StartEvent.class);
        supportedTypes.add(EndEvent.class);
        supportedTypes.add(ExclusiveGateway.class);
        supportedTypes.add(InclusiveGateway.class);
        supportedTypes.add(ParallelGateway.class);
        supportedTypes.add(ScriptTask.class);
        supportedTypes.add(ServiceTask.class);
        supportedTypes.add(BusinessRuleTask.class);
        supportedTypes.add(Task.class);
        supportedTypes.add(ManualTask.class);
        supportedTypes.add(UserTask.class);
        supportedTypes.add(SubProcess.class);
        supportedTypes.add(EventSubProcess.class);
        supportedTypes.add(CallActivity.class);
        supportedTypes.add(SendTask.class);
        supportedTypes.add(ReceiveTask.class);
        supportedTypes.add(EventGateway.class);
        supportedTypes.add(Transaction.class);
        supportedTypes.add(ThrowEvent.class);
        supportedTypes.add(TimerEventDefinition.class);
        supportedTypes.add(ErrorEventDefinition.class);
        supportedTypes.add(SignalEventDefinition.class);
        supportedTypes.add(SequenceFlow.class);
    }
}

