/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.IOSpecification;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;

public abstract class Activity
extends FlowNode {
    protected String defaultFlow;
    protected boolean forCompensation;
    protected MultiInstanceLoopCharacteristics loopCharacteristics;
    protected IOSpecification ioSpecification;
    protected List<DataAssociation> dataInputAssociations = new ArrayList<DataAssociation>();
    protected List<DataAssociation> dataOutputAssociations = new ArrayList<DataAssociation>();
    protected List<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
    protected String failedJobRetryTimeCycleValue;
    protected List<MapExceptionEntry> mapExceptions = new ArrayList<MapExceptionEntry>();

    public String getFailedJobRetryTimeCycleValue() {
        return this.failedJobRetryTimeCycleValue;
    }

    public void setFailedJobRetryTimeCycleValue(String failedJobRetryTimeCycleValue) {
        this.failedJobRetryTimeCycleValue = failedJobRetryTimeCycleValue;
    }

    public boolean isForCompensation() {
        return this.forCompensation;
    }

    public void setForCompensation(boolean forCompensation) {
        this.forCompensation = forCompensation;
    }

    public List<BoundaryEvent> getBoundaryEvents() {
        return this.boundaryEvents;
    }

    public void setBoundaryEvents(List<BoundaryEvent> boundaryEvents) {
        this.boundaryEvents = boundaryEvents;
    }

    public String getDefaultFlow() {
        return this.defaultFlow;
    }

    public void setDefaultFlow(String defaultFlow) {
        this.defaultFlow = defaultFlow;
    }

    public MultiInstanceLoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    public void setLoopCharacteristics(MultiInstanceLoopCharacteristics loopCharacteristics) {
        this.loopCharacteristics = loopCharacteristics;
    }

    public boolean hasMultiInstanceLoopCharacteristics() {
        return this.getLoopCharacteristics() != null;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    public List<DataAssociation> getDataInputAssociations() {
        return this.dataInputAssociations;
    }

    public void setDataInputAssociations(List<DataAssociation> dataInputAssociations) {
        this.dataInputAssociations = dataInputAssociations;
    }

    public List<DataAssociation> getDataOutputAssociations() {
        return this.dataOutputAssociations;
    }

    public void setDataOutputAssociations(List<DataAssociation> dataOutputAssociations) {
        this.dataOutputAssociations = dataOutputAssociations;
    }

    public List<MapExceptionEntry> getMapExceptions() {
        return this.mapExceptions;
    }

    public void setMapExceptions(List<MapExceptionEntry> mapExceptions) {
        this.mapExceptions = mapExceptions;
    }

    public void setValues(Activity otherActivity) {
        super.setValues(otherActivity);
        this.setFailedJobRetryTimeCycleValue(otherActivity.getFailedJobRetryTimeCycleValue());
        this.setDefaultFlow(otherActivity.getDefaultFlow());
        this.setForCompensation(otherActivity.isForCompensation());
        if (otherActivity.getLoopCharacteristics() != null) {
            this.setLoopCharacteristics(otherActivity.getLoopCharacteristics().clone());
        }
        if (otherActivity.getIoSpecification() != null) {
            this.setIoSpecification(otherActivity.getIoSpecification().clone());
        }
        this.dataInputAssociations = new ArrayList<DataAssociation>();
        if (otherActivity.getDataInputAssociations() != null && !otherActivity.getDataInputAssociations().isEmpty()) {
            for (DataAssociation association : otherActivity.getDataInputAssociations()) {
                this.dataInputAssociations.add(association.clone());
            }
        }
        this.dataOutputAssociations = new ArrayList<DataAssociation>();
        if (otherActivity.getDataOutputAssociations() != null && !otherActivity.getDataOutputAssociations().isEmpty()) {
            for (DataAssociation association : otherActivity.getDataOutputAssociations()) {
                this.dataOutputAssociations.add(association.clone());
            }
        }
        this.boundaryEvents.clear();
        for (BoundaryEvent event : otherActivity.getBoundaryEvents()) {
            this.boundaryEvents.add(event);
        }
    }
}

