/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.test.impl.AppTestHelper;
import org.flowable.common.engine.api.FlowableException;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

@Deprecated(forRemoval=true, since="7.2.0")
public class FlowableAppRule
implements TestRule {
    protected String configurationResource = "flowable.app.cfg.xml";
    protected String deploymentId;
    protected AppEngineConfiguration appEngineConfiguration;
    protected AppEngine appEngine;
    protected AppRepositoryService appRepositoryService;
    protected AppManagementService appManagementService;

    public FlowableAppRule() {
    }

    public FlowableAppRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableAppRule(AppEngine appEngine) {
        this.setAppEngine(appEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableAppRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableAppRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableAppRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableAppRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableAppRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.appEngine == null) {
            this.initializeAppEngine();
        }
        if (this.appEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureAppEngine();
        try {
            this.deploymentId = AppTestHelper.annotationDeploymentSetUp(this.appEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    protected void initializeAppEngine() {
        this.appEngine = AppTestHelper.getAppEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.appEngineConfiguration = this.appEngine.getAppEngineConfiguration();
        this.appRepositoryService = this.appEngine.getAppRepositoryService();
        this.appManagementService = this.appEngine.getAppManagementService();
    }

    protected void configureAppEngine() {
    }

    protected void finished(Description description) {
        try {
            AppTestHelper.annotationDeploymentTearDown(this.appEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
        this.appEngineConfiguration.getClock().reset();
    }

    public void setCurrentTime(Date currentTime) {
        this.appEngineConfiguration.getClock().setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public AppEngine getAppEngine() {
        return this.appEngine;
    }

    public void setAppEngine(AppEngine appEngine) {
        this.appEngine = appEngine;
        this.initializeServices();
    }

    public AppRepositoryService getAppRepositoryService() {
        return this.appRepositoryService;
    }

    public AppManagementService getAppManagementService() {
        return this.appManagementService;
    }
}

