/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.repository.AppDeploymentBuilderImpl;
import org.flowable.app.engine.impl.repository.AppDeploymentQueryImpl;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeployCmd
implements Command<AppDeployment> {
    protected AppDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(AppDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public AppDeployment execute(CommandContext commandContext) {
        AppEngineConfiguration appEngineConfiguration = CommandContextUtil.getAppEngineConfiguration(commandContext);
        AppDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList existingDeployments = new ArrayList();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = ((AppDeploymentQuery)new AppDeploymentQueryImpl(appEngineConfiguration.getCommandExecutor()).deploymentName(deployment.getName()).orderByDeploymenTime().desc()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add(deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((AppDeploymentQuery)appEngineConfiguration.getAppRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentId().desc()).list();
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            AppDeploymentEntity existingDeployment = null;
            if (!existingDeployments.isEmpty()) {
                existingDeployment = (AppDeploymentEntity)existingDeployments.get(0);
            }
            if (existingDeployment != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
                return existingDeployment;
            }
        }
        deployment.setDeploymentTime(appEngineConfiguration.getClock().getCurrentTime());
        deployment.setNew(true);
        CommandContextUtil.getAppDeploymentEntityManager(commandContext).insert(deployment);
        appEngineConfiguration.getDeploymentManager().deploy((EngineDeployment)deployment, null);
        return deployment;
    }

    protected boolean deploymentsDiffer(AppDeploymentEntity deployment, AppDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map resources = deployment.getResources();
        Map savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            EngineResource savedResource = (EngineResource)savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            EngineResource resource = (EngineResource)resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

