/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AbstractAppEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntity;
import org.flowable.app.engine.impl.persistence.entity.data.AppDeploymentDataManager;
import org.flowable.app.engine.impl.repository.AppDeploymentQueryImpl;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class AppDeploymentEntityManagerImpl
extends AbstractAppEntityManager<AppDeploymentEntity>
implements AppDeploymentEntityManager {
    protected AppDeploymentDataManager deploymentDataManager;

    public AppDeploymentEntityManagerImpl(AppEngineConfiguration appEngineConfiguration, AppDeploymentDataManager deploymentDataManager) {
        super(appEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<AppDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(AppDeploymentEntity deployment) {
        super.insert(deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getAppResourceEntityManager().insert((AppResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeploymentAndRelatedData(String deploymentId, boolean cascade) {
        AppDefinitionEntityManager appDefinitionEntityManager = this.getAppDefinitionEntityManager();
        List appDefinitions = appDefinitionEntityManager.createAppDefinitionQuery().deploymentId(deploymentId).list();
        for (AppDefinition appDefinition : appDefinitions) {
            if (cascade) {
                appDefinitionEntityManager.deleteAppDefinitionAndRelatedData(appDefinition.getId());
                continue;
            }
            appDefinitionEntityManager.delete(appDefinition.getId());
        }
        this.getAppResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    @Override
    public AppDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return this.deploymentDataManager.findLatestDeploymentByName(deploymentName);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public AppDeploymentQuery createDeploymentQuery() {
        return new AppDeploymentQueryImpl(this.appEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<AppDeployment> findDeploymentsByQueryCriteria(AppDeploymentQuery deploymentQuery) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria((AppDeploymentQueryImpl)deploymentQuery);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(AppDeploymentQuery deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria((AppDeploymentQueryImpl)deploymentQuery);
    }

    public AppDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(AppDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

