/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class SetVariableCmd
implements Command<Void> {
    protected String appDefinitionId;
    protected String variableName;
    protected Object variableValue;

    public SetVariableCmd(String appDefinitionId, String variableName, Object variableValue) {
        this.appDefinitionId = appDefinitionId;
        this.variableName = variableName;
        this.variableValue = variableValue;
    }

    public Void execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variable name is null");
        }
        VariableTypes variableTypes = CommandContextUtil.getAppEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(this.variableValue);
        VariableService variableService = CommandContextUtil.getVariableService(commandContext);
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(this.variableName, type, this.variableValue);
        variableInstance.setScopeId(this.appDefinitionId);
        variableInstance.setScopeType("app");
        variableService.updateVariableInstance(variableInstance);
        return null;
    }
}

