/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class AppRestUrlBuilder {
    protected String baseUrl = "";

    protected AppRestUrlBuilder() {
    }

    protected AppRestUrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String buildUrl(String[] fragments, Object ... arguments) {
        return this.baseUrl + "/" + MessageFormat.format(StringUtils.join((Object[])fragments, (char)'/'), arguments);
    }

    public static AppRestUrlBuilder usingBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new FlowableIllegalArgumentException("baseUrl can not be null");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return new AppRestUrlBuilder(baseUrl);
    }

    public static AppRestUrlBuilder fromRequest(HttpServletRequest request) {
        return AppRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).build().toUriString());
    }

    public static AppRestUrlBuilder fromCurrentRequest() {
        return AppRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString());
    }
}

