/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flinkx.api.serializer.CaseClassSerializer;
import scala.Product;

@Internal
public final class ScalaCaseClassSerializerSnapshot<T extends Product>
extends CompositeTypeSerializerSnapshot<T, CaseClassSerializer<T>> {
    private static final int VERSION = 3;
    private Class<T> type;
    private boolean isCaseClassImmutable;

    public ScalaCaseClassSerializerSnapshot() {
        super(CaseClassSerializer.class);
    }

    public ScalaCaseClassSerializerSnapshot(CaseClassSerializer<T> caseClassSerializer) {
        super(caseClassSerializer);
        this.type = (Class)Preconditions.checkNotNull((Object)caseClassSerializer.getTupleClass(), (String)"tuple class can not be NULL");
        this.isCaseClassImmutable = caseClassSerializer.isCaseClassImmutable();
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 3;
    }

    protected TypeSerializer<?>[] getNestedSerializers(CaseClassSerializer<T> caseClassSerializer) {
        return caseClassSerializer.getFieldSerializers();
    }

    protected CaseClassSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] typeSerializerArray) {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        return new CaseClassSerializer<T>(this.type, typeSerializerArray, this.isCaseClassImmutable);
    }

    protected void writeOuterSnapshot(DataOutputView dataOutputView) throws IOException {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        dataOutputView.writeUTF(this.type.getName());
        dataOutputView.writeBoolean(this.isCaseClassImmutable);
    }

    protected void readOuterSnapshot(int n, DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        this.type = InstantiationUtil.resolveClassByName((DataInputView)dataInputView, (ClassLoader)classLoader);
        this.isCaseClassImmutable = n > 2 && dataInputView.readBoolean();
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(CaseClassSerializer<T> caseClassSerializer) {
        Optional<String> optional;
        Optional<String> optional2 = Optional.ofNullable(this.type).map(Class::getName);
        if (optional2.equals(optional = Optional.ofNullable(caseClassSerializer.getTupleClass()).map(Class::getName))) {
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }
        return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }
}

