/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flinkx.api.serializer.ScalaCaseClassSerializer;
import scala.Product;

@Internal
public final class ScalaCaseClassSerializerSnapshot<T extends Product>
extends CompositeTypeSerializerSnapshot<T, ScalaCaseClassSerializer<T>> {
    private static final int VERSION = 2;
    private Class<T> type;

    public ScalaCaseClassSerializerSnapshot() {
        super(ScalaCaseClassSerializer.class);
    }

    public ScalaCaseClassSerializerSnapshot(ScalaCaseClassSerializer<T> scalaCaseClassSerializer) {
        super(scalaCaseClassSerializer);
        this.type = (Class)Preconditions.checkNotNull((Object)scalaCaseClassSerializer.getTupleClass(), (String)"tuple class can not be NULL");
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    protected TypeSerializer<?>[] getNestedSerializers(ScalaCaseClassSerializer<T> scalaCaseClassSerializer) {
        return scalaCaseClassSerializer.getFieldSerializers();
    }

    protected ScalaCaseClassSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] typeSerializerArray) {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        return new ScalaCaseClassSerializer<T>(this.type, typeSerializerArray);
    }

    protected void writeOuterSnapshot(DataOutputView dataOutputView) throws IOException {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        dataOutputView.writeUTF(this.type.getName());
    }

    protected void readOuterSnapshot(int n, DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        this.type = InstantiationUtil.resolveClassByName((DataInputView)dataInputView, (ClassLoader)classLoader);
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(ScalaCaseClassSerializer<T> scalaCaseClassSerializer) {
        Optional<String> optional;
        Optional<String> optional2 = Optional.ofNullable(this.type).map(Class::getName);
        if (optional2.equals(optional = Optional.ofNullable(scalaCaseClassSerializer.getTupleClass()).map(Class::getName))) {
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }
        return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }
}

