/*
 * Decompiled with CFR 0.152.
 */
package org.fizmo.dropwizard.guice;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.GuiceFilter;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.metrics.core.HealthCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.fizmo.dropwizard.guice.ConfiguredModule;
import org.fizmo.dropwizard.guice.DropwizardModule;

public class GuiceBundle<T>
implements ConfiguredBundle<T> {
    private final Iterable<Module> modules;
    private final Optional<Injector> parentInjector;
    private static final Key<Set<HealthCheck>> healthChecksKey = Key.get((TypeLiteral)new TypeLiteral<Set<HealthCheck>>(){});

    private GuiceBundle(Iterable<Module> modules, Optional<Injector> parentInjector) {
        this.modules = modules;
        this.parentInjector = parentInjector;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        Iterable<Module> configedModules = this.configureModules(configuration, this.modules);
        DropwizardModule<T> dwModule = new DropwizardModule<T>(configuration, environment);
        Injector injector = ((Injector)this.parentInjector.or((Object)Guice.createInjector((Module[])new Module[0]))).createChildInjector(Iterables.concat((Iterable)ImmutableList.of(dwModule), configedModules));
        environment.addFilter((Filter)injector.getInstance(GuiceFilter.class), "*");
        if (!injector.findBindingsByType(healthChecksKey.getTypeLiteral()).isEmpty()) {
            Set healthChecks = (Set)injector.getInstance(healthChecksKey);
            for (HealthCheck hc : healthChecks) {
                environment.addHealthCheck(hc);
            }
        }
    }

    private Iterable<Module> configureModules(T config, Iterable<Module> modules) {
        ArrayList configedModules = Lists.newArrayList();
        for (Module m : modules) {
            if (m instanceof ConfiguredModule) {
                ConfiguredModule cm = (ConfiguredModule)m;
                configedModules.add(cm.withConfiguration(config));
                continue;
            }
            configedModules.add(m);
        }
        return configedModules;
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public ParentedBuilder withParent(Injector parentInjector) {
            return (ParentedBuilder)new ParentedBuilder(parentInjector).withModules(this.modules());
        }

        public StagedBuilder withStage(Stage stage) {
            return (StagedBuilder)new StagedBuilder(stage).withModules(this.modules());
        }

        @Override
        protected Optional<Injector> injector() {
            return Optional.absent();
        }
    }

    public static class StagedBuilder
    extends AbstractBuilder<StagedBuilder> {
        private final Stage stage;

        StagedBuilder(Stage stage) {
            this.stage = stage;
        }

        @Override
        protected StagedBuilder self() {
            return this;
        }

        @Override
        protected Optional<Injector> injector() {
            return Optional.of((Object)Guice.createInjector((Stage)this.stage, (Module[])new Module[0]));
        }
    }

    public static class ParentedBuilder
    extends AbstractBuilder<ParentedBuilder> {
        private final Injector parentInjector;

        ParentedBuilder(Injector parentInjector) {
            this.parentInjector = parentInjector;
        }

        @Override
        protected ParentedBuilder self() {
            return this;
        }

        @Override
        protected Optional<Injector> injector() {
            return Optional.of((Object)this.parentInjector);
        }
    }

    private static abstract class AbstractBuilder<T extends AbstractBuilder> {
        private final List<Module> modules = new LinkedList<Module>();

        protected AbstractBuilder() {
        }

        protected abstract T self();

        protected abstract Optional<Injector> injector();

        public T withModules(Module module) {
            this.modules.add(module);
            return this.self();
        }

        public T withModules(Module module1, Module module2, Module ... otherModules) {
            this.modules.add(module1);
            this.modules.add(module2);
            Collections.addAll(this.modules, otherModules);
            return this.self();
        }

        public T withModules(Iterable<Module> newModules) {
            for (Module m : newModules) {
                this.modules.add(m);
            }
            return this.self();
        }

        protected Collection<Module> modules() {
            return this.modules;
        }

        public <CT extends Configuration> GuiceBundle<CT> build() {
            return new GuiceBundle(this.modules(), this.injector());
        }
    }
}

