/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.web3j.abi.FunctionReturnDecoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.abi.datatypes.Utf8String;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.fisco.bcos.web3j.utils.Numeric;
import org.fisco.bcos.web3j.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertResolver {
    private static final Logger logger = LoggerFactory.getLogger(RevertResolver.class);
    public static final String RevertMethod = "08c379a0";
    public static final String RevertMethodWithHexPrefix = "0x08c379a0";
    public static final String SMRevertMethod = "c703cb12";
    public static final String SMRevertMethodWithHexPrefix = "0xc703cb12";
    public static final Function revertFunction = new Function("Error", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));

    public static boolean isOutputStartWithRevertMethod(String output) {
        return output.startsWith(RevertMethodWithHexPrefix) || output.startsWith(SMRevertMethodWithHexPrefix) || output.startsWith(RevertMethod) || output.startsWith(SMRevertMethod);
    }

    public static boolean hasRevertMessage(String status, String output) {
        if (Strings.isEmpty(status) || Strings.isEmpty(output)) {
            return false;
        }
        try {
            BigInteger statusQuantity = Numeric.decodeQuantity(status);
            return !BigInteger.ZERO.equals(statusQuantity) && RevertResolver.isOutputStartWithRevertMethod(output);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Tuple2<Boolean, String> tryResolveRevertMessage(String status, String output) {
        if (!RevertResolver.hasRevertMessage(status, output)) {
            return new Tuple2<Boolean, Object>(false, null);
        }
        try {
            String rawOutput = Numeric.containsHexPrefix(output) ? output.substring(RevertMethodWithHexPrefix.length()) : output.substring(RevertMethod.length());
            List<Type> result = FunctionReturnDecoder.decode(rawOutput, revertFunction.getOutputParameters());
            if (result.get(0) instanceof Utf8String) {
                String message = ((Utf8String)result.get(0)).getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug(" ABI: {} , RevertMessage: {}", (Object)output, (Object)message);
                }
                return new Tuple2<Boolean, String>(true, message);
            }
        }
        catch (Exception e) {
            logger.warn(" ABI: {}, e: {}", (Object)output, (Object)e);
        }
        return new Tuple2<Boolean, Object>(false, null);
    }

    public static Tuple2<Boolean, String> tryResolveRevertMessage(TransactionReceipt receipt) {
        return RevertResolver.tryResolveRevertMessage(receipt.getStatus(), receipt.getOutput());
    }
}

