/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.solidity.compiler;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.fisco.bcos.web3j.solidity.compiler.ContractException;

public class SourceArtifact {
    private String name;
    private List<String> dependencies;
    private String source;
    private final Set<SourceArtifact> injectedDependencies = new HashSet<SourceArtifact>();
    private final Set<SourceArtifact> dependentArtifacts = new HashSet<SourceArtifact>();

    public SourceArtifact(String name, String source) {
        this.name = name;
        this.dependencies = SourceArtifact.extractDependencies(source);
        this.source = source.replaceAll("import\\s\"\\.*?\\.sol\";", "");
    }

    public SourceArtifact(File f) {
    }

    private static List<String> extractDependencies(String source) {
        String[] deps = StringUtils.substringsBetween((String)source, (String)"import \"", (String)"\";");
        return deps == null ? Collections.emptyList() : Arrays.asList(deps);
    }

    public void injectDependency(SourceArtifact srcArtifact) {
        this.injectedDependencies.add(srcArtifact);
        srcArtifact.addDependentArtifact(this);
    }

    private void addDependentArtifact(SourceArtifact srcArtifact) {
        this.dependentArtifacts.add(srcArtifact);
    }

    public boolean hasDependentArtifacts() {
        return !this.dependentArtifacts.isEmpty();
    }

    private Collection<String> getUnresolvedDependencies() {
        HashSet<String> ret = new HashSet<String>();
        for (SourceArtifact injectedDependency : this.injectedDependencies) {
            ret.add(injectedDependency.getName());
        }
        return CollectionUtils.disjunction(this.dependencies, ret);
    }

    public String plainSource() {
        Collection<String> unresolvedDeps = this.getUnresolvedDependencies();
        if (CollectionUtils.isNotEmpty(unresolvedDeps)) {
            throw ContractException.assembleError("Followed dependencies aren't resolved: %s", unresolvedDeps);
        }
        String result = this.source;
        for (SourceArtifact dependencyArtifact : this.injectedDependencies) {
            String importDefinition = String.format("import \"%s\";", dependencyArtifact.getName());
            String dependencySrc = String.format("// %s\n%s", importDefinition, dependencyArtifact.plainSource());
            result = result.replace(importDefinition, dependencySrc);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }
}

