/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.solidity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.solidity.SolidityType;
import org.fisco.bcos.web3j.utils.ByteUtil;

public class Abi
extends ArrayList<Entry> {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);

    public static Abi fromJson(String json) {
        try {
            return (Abi)DEFAULT_MAPPER.readValue(json, Abi.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        try {
            return ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends Entry> T find(Class<T> resultClass, Entry.Type type, Predicate<T> searchPredicate) {
        return (T)((Entry)CollectionUtils.find((Iterable)this, entry -> entry.type == type && searchPredicate.evaluate(entry)));
    }

    public Function findFunction(Predicate<Function> searchPredicate) {
        return this.find(Function.class, Entry.Type.function, searchPredicate);
    }

    public Event findEvent(Predicate<Event> searchPredicate) {
        return this.find(Event.class, Entry.Type.event, searchPredicate);
    }

    public Constructor findConstructor() {
        return this.find(Constructor.class, Entry.Type.constructor, object -> true);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static class Event
    extends Entry {
        public Event(boolean anonymous, String name, List<Entry.Param> inputs, List<Entry.Param> outputs) {
            super(anonymous, null, name, inputs, outputs, Entry.Type.event, false);
        }

        public List<?> decode(byte[] data, byte[][] topics) {
            ArrayList result = new ArrayList(this.inputs.size());
            byte[][] argTopics = this.anonymous != false ? topics : (byte[][])ArrayUtils.subarray((Object[])topics, (int)1, (int)topics.length);
            List<Entry.Param> indexedParams = this.filteredInputs(true);
            ArrayList<byte[]> indexed = new ArrayList<byte[]>();
            for (int i = 0; i < indexedParams.size(); ++i) {
                Object decodedTopic = indexedParams.get((int)i).type.isDynamicType() ? SolidityType.Bytes32Type.decodeBytes32(argTopics[i], 0) : (Object)indexedParams.get((int)i).type.decode(argTopics[i]);
                indexed.add((byte[])decodedTopic);
            }
            List<?> notIndexed = Entry.Param.decodeList(this.filteredInputs(false), data);
            for (Entry.Param input : this.inputs) {
                result.add(input.indexed != false ? indexed.remove(0) : notIndexed.remove(0));
            }
            return result;
        }

        private List<Entry.Param> filteredInputs(boolean indexed) {
            return ListUtils.select((Collection)this.inputs, param -> param.indexed == indexed);
        }

        public String toString() {
            return String.format("event %s(%s);", this.name, StringUtils.join((Iterable)this.inputs, (String)", "));
        }
    }

    public static class Function
    extends Entry {
        private static final int ENCODED_SIGN_LENGTH = 4;

        public Function(boolean constant, String name, List<Entry.Param> inputs, List<Entry.Param> outputs, Boolean payable) {
            super(null, constant, name, inputs, outputs, Entry.Type.function, payable);
        }

        public byte[] encode(Object ... args) {
            return ByteUtil.merge(this.encodeSignature(), this.encodeArguments(args));
        }

        private byte[] encodeArguments(Object ... args) {
            if (args.length > this.inputs.size()) {
                throw new RuntimeException("Too many arguments: " + args.length + " > " + this.inputs.size());
            }
            int staticSize = 0;
            int dynamicCnt = 0;
            for (int i = 0; i < args.length; ++i) {
                SolidityType type = ((Entry.Param)this.inputs.get((int)i)).type;
                if (type.isDynamicType()) {
                    ++dynamicCnt;
                }
                staticSize += type.getFixedSize();
            }
            byte[][] bb = new byte[args.length + dynamicCnt][];
            int curDynamicPtr = staticSize;
            int curDynamicCnt = 0;
            for (int i = 0; i < args.length; ++i) {
                SolidityType type = ((Entry.Param)this.inputs.get((int)i)).type;
                if (type.isDynamicType()) {
                    byte[] dynBB = type.encode(args[i]);
                    bb[i] = SolidityType.IntType.encodeInt(curDynamicPtr);
                    bb[args.length + curDynamicCnt] = dynBB;
                    ++curDynamicCnt;
                    curDynamicPtr += dynBB.length;
                    continue;
                }
                bb[i] = type.encode(args[i]);
            }
            return ByteUtil.merge(bb);
        }

        public List<?> decode(byte[] encoded) {
            return Entry.Param.decodeList(this.inputs, ArrayUtils.subarray((byte[])encoded, (int)4, (int)encoded.length));
        }

        public List<?> decodeResult(byte[] encoded) {
            return Entry.Param.decodeList(this.outputs, encoded);
        }

        @Override
        public byte[] encodeSignature() {
            return Function.extractSignature(super.encodeSignature());
        }

        public static byte[] extractSignature(byte[] data) {
            return ArrayUtils.subarray((byte[])data, (int)0, (int)4);
        }

        public String toString() {
            String returnTail = "";
            if (this.constant.booleanValue()) {
                returnTail = returnTail + " constant";
            }
            if (!this.outputs.isEmpty()) {
                ArrayList<String> types = new ArrayList<String>();
                for (Entry.Param output : this.outputs) {
                    types.add(output.type.getCanonicalName());
                }
                returnTail = returnTail + String.format(" returns(%s)", StringUtils.join(types, (String)", "));
            }
            return String.format("function %s(%s)%s;", this.name, StringUtils.join((Iterable)this.inputs, (String)", "), returnTail);
        }
    }

    public static class Constructor
    extends Entry {
        public Constructor(List<Entry.Param> inputs, List<Entry.Param> outputs) {
            super(null, null, "", inputs, outputs, Entry.Type.constructor, false);
        }

        public List<?> decode(byte[] encoded) {
            return Entry.Param.decodeList(this.inputs, encoded);
        }

        public String formatSignature(String contractName) {
            return String.format("function %s(%s)", contractName, StringUtils.join((Iterable)this.inputs, (String)", "));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class Entry {
        public final Boolean anonymous;
        public final Boolean constant;
        public final String name;
        public final List<Param> inputs;
        public final List<Param> outputs;
        public final Type type;
        public final Boolean payable;

        public Entry(Boolean anonymous, Boolean constant, String name, List<Param> inputs, List<Param> outputs, Type type, Boolean payable) {
            this.anonymous = anonymous;
            this.constant = constant;
            this.name = name;
            this.inputs = inputs;
            this.outputs = outputs;
            this.type = type;
            this.payable = payable;
        }

        public String formatSignature() {
            StringBuilder paramsTypes = new StringBuilder();
            for (Param param : this.inputs) {
                paramsTypes.append(param.type.getCanonicalName()).append(",");
            }
            return String.format("%s(%s)", this.name, StringUtils.stripEnd((String)paramsTypes.toString(), (String)","));
        }

        public byte[] fingerprintSignature() {
            return Hash.sha3(this.formatSignature().getBytes());
        }

        public byte[] encodeSignature() {
            return this.fingerprintSignature();
        }

        @JsonCreator
        public static Entry create(@JsonProperty(value="anonymous") boolean anonymous, @JsonProperty(value="constant") boolean constant, @JsonProperty(value="name") String name, @JsonProperty(value="inputs") List<Param> inputs, @JsonProperty(value="outputs") List<Param> outputs, @JsonProperty(value="type") Type type, @JsonProperty(value="payable", required=false, defaultValue="false") Boolean payable) {
            Entry result = null;
            switch (type) {
                case constructor: {
                    result = new Constructor(inputs, outputs);
                    break;
                }
                case function: 
                case fallback: {
                    result = new Function(constant, name, inputs, outputs, payable);
                    break;
                }
                case event: {
                    result = new Event(anonymous, name, inputs, outputs);
                }
            }
            return result;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Param {
            public Boolean indexed;
            public String name;
            public SolidityType type;

            public static List<?> decodeList(List<Param> params, byte[] encoded) {
                ArrayList<Object> result = new ArrayList<Object>(params.size());
                int offset = 0;
                for (Param param : params) {
                    Object decoded = param.type.isDynamicType() ? param.type.decode(encoded, SolidityType.IntType.decodeInt(encoded, offset).intValue()) : param.type.decode(encoded, offset);
                    result.add(decoded);
                    offset += param.type.getFixedSize();
                }
                return result;
            }

            public String toString() {
                return String.format("%s%s%s", this.type.getCanonicalName(), this.indexed != null && this.indexed != false ? " indexed " : " ", this.name);
            }
        }

        public static enum Type {
            constructor,
            function,
            event,
            fallback;

        }
    }
}

