/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.MerkleProofUnit;
import org.fisco.bcos.web3j.utils.Numeric;

public class TransactionReceipt {
    private String transactionHash;
    private String transactionIndex;
    private String blockHash;
    private String blockNumber;
    private String gasUsed;
    private String contractAddress;
    private String root;
    private String status;
    private String message;
    private String from;
    private String to;
    private String input;
    private String output;
    private List<Log> logs;
    private String logsBloom;
    private List<MerkleProofUnit> txProof;
    private List<MerkleProofUnit> receiptProof;

    public TransactionReceipt() {
    }

    public TransactionReceipt(String transactionHash, String transactionIndex, String blockHash, String blockNumber, String gasUsed, String contractAddress, String root, String status, String message, String from, String to, String input, String output, List<Log> logs, String logsBloom) {
        this.transactionHash = transactionHash;
        this.transactionIndex = transactionIndex;
        this.blockHash = blockHash;
        this.blockNumber = blockNumber;
        this.gasUsed = gasUsed;
        this.contractAddress = contractAddress;
        this.root = root;
        this.status = status;
        this.message = message;
        this.from = from;
        this.to = to;
        this.input = input;
        this.output = output;
        this.logs = logs;
        this.logsBloom = logsBloom;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public BigInteger getTransactionIndex() {
        return Numeric.decodeQuantity(this.transactionIndex);
    }

    @JsonIgnore
    public String getTransactionIndexRaw() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public BigInteger getBlockNumber() {
        return Numeric.decodeQuantity(this.blockNumber);
    }

    @JsonIgnore
    public String getBlockNumberRaw() {
        return this.blockNumber;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public BigInteger getGasUsed() {
        return Numeric.decodeQuantity(this.gasUsed);
    }

    @JsonIgnore
    public String getGasUsedRaw() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public boolean isStatusOK() {
        if (null == this.status) {
            return true;
        }
        try {
            BigInteger statusQuantity = Numeric.decodeQuantity(this.status);
            return BigInteger.ZERO.equals(statusQuantity);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public List<MerkleProofUnit> getTxProof() {
        return this.txProof;
    }

    public void setTxProof(List<MerkleProofUnit> txProof) {
        this.txProof = txProof;
    }

    public List<MerkleProofUnit> getReceiptProof() {
        return this.receiptProof;
    }

    public void setReceiptProof(List<MerkleProofUnit> receiptProof) {
        this.receiptProof = receiptProof;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionReceipt)) {
            return false;
        }
        TransactionReceipt that = (TransactionReceipt)o;
        if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(that.getTransactionHash()) : that.getTransactionHash() != null) {
            return false;
        }
        if (this.transactionIndex != null ? !this.transactionIndex.equals(that.transactionIndex) : that.transactionIndex != null) {
            return false;
        }
        if (this.getBlockHash() != null ? !this.getBlockHash().equals(that.getBlockHash()) : that.getBlockHash() != null) {
            return false;
        }
        if (this.blockNumber != null ? !this.blockNumber.equals(that.blockNumber) : that.blockNumber != null) {
            return false;
        }
        if (this.gasUsed != null ? !this.gasUsed.equals(that.gasUsed) : that.gasUsed != null) {
            return false;
        }
        if (this.getContractAddress() != null ? !this.getContractAddress().equals(that.getContractAddress()) : that.getContractAddress() != null) {
            return false;
        }
        if (this.getRoot() != null ? !this.getRoot().equals(that.getRoot()) : that.getRoot() != null) {
            return false;
        }
        if (this.getStatus() != null ? !this.getStatus().equals(that.getStatus()) : that.getStatus() != null) {
            return false;
        }
        if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
            return false;
        }
        if (this.getTo() != null ? !this.getTo().equals(that.getTo()) : that.getTo() != null) {
            return false;
        }
        if (this.getLogs() != null ? !this.getLogs().equals(that.getLogs()) : that.getLogs() != null) {
            return false;
        }
        if (this.getOutput() != null ? !this.getOutput().equals(that.getOutput()) : that.getOutput() != null) {
            return false;
        }
        if (this.getInput() != null ? !this.getInput().equals(that.getInput()) : that.getInput() != null) {
            return false;
        }
        return this.getLogsBloom() != null ? this.getLogsBloom().equals(that.getLogsBloom()) : that.getLogsBloom() == null;
    }

    public int hashCode() {
        int result = this.getTransactionHash() != null ? this.getTransactionHash().hashCode() : 0;
        result = 31 * result + (this.transactionIndex != null ? this.transactionIndex.hashCode() : 0);
        result = 31 * result + (this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0);
        result = 31 * result + (this.blockNumber != null ? this.blockNumber.hashCode() : 0);
        result = 31 * result + (this.gasUsed != null ? this.gasUsed.hashCode() : 0);
        result = 31 * result + (this.getContractAddress() != null ? this.getContractAddress().hashCode() : 0);
        result = 31 * result + (this.getRoot() != null ? this.getRoot().hashCode() : 0);
        result = 31 * result + (this.getStatus() != null ? this.getStatus().hashCode() : 0);
        result = 31 * result + (this.getFrom() != null ? this.getFrom().hashCode() : 0);
        result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
        result = 31 * result + (this.getOutput() != null ? this.getOutput().hashCode() : 0);
        result = 31 * result + (this.getInput() != null ? this.getInput().hashCode() : 0);
        result = 31 * result + (this.getLogs() != null ? this.getLogs().hashCode() : 0);
        result = 31 * result + (this.getLogsBloom() != null ? this.getLogsBloom().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TransactionReceipt{transactionHash='" + this.transactionHash + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", blockHash='" + this.blockHash + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", contractAddress='" + this.contractAddress + '\'' + ", root='" + this.root + '\'' + ", status='" + this.status + '\'' + ", message='" + this.message + '\'' + ", from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", input='" + this.input + '\'' + ", output='" + this.output + '\'' + ", logs=" + this.logs + ", logsBloom='" + this.logsBloom + '\'' + ", transAndProof=" + this.txProof + ", receiptAndProof=" + this.receiptProof + '}';
    }
}

