/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.fisco.bcos.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transaction {
    public static final BigInteger DEFAULT_GAS = BigInteger.valueOf(9000L);
    private String from;
    private String to;
    private BigInteger gas;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;
    private BigInteger nonce;
    private BigInteger type;
    private String contractName;

    public Transaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this.from = from;
        this.to = to;
        this.gas = gasLimit;
        this.gasPrice = gasPrice;
        this.value = value;
        if (data != null) {
            this.data = this.to != null && !this.to.equals("") ? Numeric.prependHexPrefix(data) : data;
        }
        this.nonce = nonce;
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new Transaction(from, nonce, gasPrice, gasLimit, null, value, init);
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, String init) {
        return Transaction.createContractTransaction(from, nonce, gasPrice, null, null, init);
    }

    public static Transaction createEtherTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, null);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, data);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, null, data);
    }

    public static Transaction createEthCallTransaction(String from, String to, String data) {
        return new Transaction(from, null, null, null, to, null, data);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return Transaction.convert(this.gas);
    }

    public String getGasPrice() {
        return Transaction.convert(this.gasPrice);
    }

    public String getValue() {
        return Transaction.convert(this.value);
    }

    public String getData() {
        return this.data;
    }

    public String getNonce() {
        return Transaction.convert(this.nonce);
    }

    public String getContractName() {
        return this.contractName;
    }

    public String getType() {
        return Transaction.convert(this.type);
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity(value);
        }
        return null;
    }
}

