/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.consensus;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.consensus.Consensus;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class ConsensusService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static String ConsensusPrecompileAddress = "0x0000000000000000000000000000000000001003";
    private Web3j web3j;
    private Consensus consensus;

    public ConsensusService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.web3j = web3j;
        this.consensus = Consensus.load(ConsensusPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
    }

    public String addSealer(String nodeID) throws Exception {
        if (!this.isValidNodeID(nodeID)) {
            return PrecompiledCommon.transferToJson(-51102);
        }
        List sealerList = (List)this.web3j.getSealerList().send().getResult();
        if (sealerList.contains(nodeID)) {
            return PrecompiledCommon.transferToJson(-51104);
        }
        TransactionReceipt receipt = this.consensus.addSealer(nodeID).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public String addObserver(String nodeID) throws Exception {
        if (!this.isValidNodeID(nodeID)) {
            return PrecompiledCommon.transferToJson(-51102);
        }
        List observerList = (List)this.web3j.getObserverList().send().getResult();
        if (observerList.contains(nodeID)) {
            return PrecompiledCommon.transferToJson(-51105);
        }
        TransactionReceipt receipt = this.consensus.addObserver(nodeID).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public String removeNode(String nodeId) throws Exception {
        List groupPeers = (List)this.web3j.getGroupPeers().send().getResult();
        if (!groupPeers.contains(nodeId)) {
            return PrecompiledCommon.transferToJson(-51103);
        }
        TransactionReceipt receipt = new TransactionReceipt();
        try {
            receipt = this.consensus.remove(nodeId).send();
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("Don't send requests to this group")) {
                return PrecompiledCommon.transferToJson(0);
            }
            throw e;
        }
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    private boolean isValidNodeID(String _nodeID) throws IOException, JsonProcessingException {
        boolean flag = false;
        List nodeIDs = (List)this.web3j.getNodeIDList().send().getResult();
        for (String nodeID : nodeIDs) {
            if (!_nodeID.equals(nodeID)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

