/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.config;

import java.math.BigInteger;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.config.SystemConfig;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class SystemConfigService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static String systemConfigPrecompileAddress = "0x0000000000000000000000000000000000001000";
    private SystemConfig systemConfig;
    private Web3j web3j;

    public SystemConfigService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.systemConfig = SystemConfig.load(systemConfigPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
        this.web3j = web3j;
    }

    public String setValueByKey(String key, String value) throws Exception {
        TransactionReceipt receipt = this.systemConfig.setValueByKey(key, value).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }
}

