/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.tool;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.fisco.bcos.web3j.crypto.tool.ECCParams;

public class ECCDecrypt {
    private final BigInteger priKey;
    private final BCECPrivateKey bCECPrivateKey;

    public ECCDecrypt(BigInteger privateKey) {
        this.priKey = privateKey;
        this.bCECPrivateKey = this.createBCECPrivateKey(privateKey);
    }

    public BigInteger getPriKey() {
        return this.priKey;
    }

    public BCECPrivateKey getbCECPrivateKey() {
        return this.bCECPrivateKey;
    }

    private BCECPrivateKey createBCECPrivateKey(BigInteger privateKey) {
        ECPrivateKeySpec secretKeySpec = new ECPrivateKeySpec(privateKey, (ECParameterSpec)ECCParams.ecNamedCurveSpec);
        BCECPrivateKey bcecPrivateKey = new BCECPrivateKey("ECDSA", secretKeySpec, BouncyCastleProvider.CONFIGURATION);
        return bcecPrivateKey;
    }

    public byte[] decrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        cipher.init(2, (Key)this.getbCECPrivateKey(), (AlgorithmParameterSpec)ECCParams.IES_PARAMS);
        return cipher.doFinal(data);
    }
}

