/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm.sm3;

import org.bouncycastle.util.encoders.Hex;
import org.fisco.bcos.web3j.crypto.HashInterface;
import org.fisco.bcos.web3j.crypto.gm.sm3.SM3;
import org.fisco.bcos.web3j.utils.Numeric;
import org.fisco.bcos.web3j.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM3Digest
implements HashInterface {
    static Logger logger = LoggerFactory.getLogger(SM3Digest.class);
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])SM3.iv.clone();
    private int cntBlock = 0;

    @Override
    public String hash(String hexInput) {
        byte[] md = new byte[32];
        byte[] msg = Numeric.hexStringToByteArray(hexInput);
        logger.debug("sm3 hash origData:{}", (Object)hexInput);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg, 0, msg.length);
        sm3.doFinal(md, 0);
        logger.debug("sm3 hash data:{}", (Object)Hex.toHexString((byte[])md));
        return Numeric.toHexString(md);
    }

    @Override
    public byte[] hash(byte[] input, int offset, int length) {
        byte[] md = new byte[32];
        logger.debug("sm3 hash origData:{}", (Object)input);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(input, offset, length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        logger.debug("sm3 hash data:{}", (Object)s);
        return md;
    }

    @Override
    public byte[] hash(byte[] input) {
        byte[] md = new byte[32];
        logger.debug("sm3 hash origData:{}", (Object)input);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(input, 0, input.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        logger.debug("sm3 hash data:{}", (Object)s);
        return md;
    }

    public SM3Digest() {
    }

    public SM3Digest(SM3Digest t) {
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        this.xBufOff = t.xBufOff;
        System.arraycopy(t.V, 0, this.V, 0, t.V.length);
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])SM3.iv.clone();
    }

    public void update(byte[] in, int inOff, int len) {
        int partLen = 64 - this.xBufOff;
        int inputLen = len;
        int dPos = inOff;
        if (partLen < inputLen) {
            System.arraycopy(in, dPos, this.xBuf, this.xBufOff, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.xBuf, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(in, dPos, this.xBuf, this.xBufOff, inputLen);
        this.xBufOff += inputLen;
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
        }
        this.xBufOff = 0;
    }

    private void doHash(byte[] B) {
        byte[] tmp = SM3.CF(this.V, B);
        System.arraycopy(tmp, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3.padding(buffer, this.cntBlock);
        for (int i = 0; i < tmp.length; i += 64) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
        }
        return this.V;
    }

    public void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }

    public int getDigestSize() {
        return 32;
    }

    public static void main(String[] args) {
        byte[] md = new byte[32];
        String strMsg = "123456";
        String strHash = "debe9ff92275b8a138604889c18e5a4d6fdb70e5387e5765293dcba39c0c5732";
        byte[] msg1 = strMsg.getBytes();
        System.out.println("\u7b7e\u540d\u539f\u6587\uff1a" + strMsg);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        System.out.println(s.toUpperCase().compareTo(strHash.toUpperCase()));
    }

    public static String cleanHexPrefix(String input) {
        if (SM3Digest.containsHexPrefix(input)) {
            return input.substring(2);
        }
        return input;
    }

    public static boolean containsHexPrefix(String input) {
        return !Strings.isEmpty(input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }
}

