/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm.sm2.crypto.asymmetric;

import java.math.BigInteger;
import java.security.PublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.fisco.bcos.web3j.crypto.gm.sm2.util.KeyUtils;

public class SM2PublicKey
implements PublicKey {
    private static final long serialVersionUID = 6196280185307032043L;
    private final String ALGORITHM = "SM2";
    private BigInteger x;
    private BigInteger y;
    private ECPoint p;

    public SM2PublicKey() {
    }

    public SM2PublicKey(ECPoint p) {
        this.p = p;
        ECPoint ecPoint = p.normalize();
        this.x = ecPoint.getAffineXCoord().toBigInteger();
        this.y = ecPoint.getAffineYCoord().toBigInteger();
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public byte[] getEncoded() {
        byte[] xBuf = this.padding(this.x.toByteArray(), 32);
        byte[] yBuf = this.padding(this.y.toByteArray(), 32);
        byte[] encoded = new byte[xBuf.length + yBuf.length];
        System.arraycopy(xBuf, 0, encoded, 0, xBuf.length);
        System.arraycopy(yBuf, 0, encoded, xBuf.length, yBuf.length);
        return encoded;
    }

    public String getPbkxHex() {
        return KeyUtils.bcdhex_to_aschex(this.padding(this.x.toByteArray(), 32));
    }

    public String getPbkyHex() {
        return KeyUtils.bcdhex_to_aschex(this.padding(this.y.toByteArray(), 32));
    }

    @Override
    public String getFormat() {
        return this.getPbkxHex() + this.getPbkyHex();
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public ECPoint getP() {
        return this.p;
    }

    public void setP(ECPoint p) {
        this.p = p;
    }

    public byte[] padding(byte[] key, int length) {
        if (key.length == length) {
            return key;
        }
        if (key.length > length) {
            byte[] dest = new byte[length];
            System.arraycopy(key, key.length - length, dest, 0, length);
            return dest;
        }
        byte[] dest = new byte[length];
        for (int i = 0; i < length - key.length; ++i) {
            dest[i] = 0;
        }
        System.arraycopy(key, 0, dest, length - key.length, key.length);
        return dest;
    }
}

